%define _unpackaged_files_terminate_build 1
%define pypi_name cloudpickle

%def_with check

Name: python3-module-%pypi_name
Version: 3.1.1
Release: alt1
Summary: Extended pickling support for Python objects
License: BSD
Group: Development/Python
Url: https://pypi.org/project/cloudpickle
VCS: https://github.com/cloudpipe/cloudpickle
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
%pyproject_builddeps_check
# for psutil
BuildRequires: /proc
BuildRequires: python3-module-numpy-testing
%endif

%description
cloudpickle makes it possible to serialize Python constructs
not supported by the default pickle module from the Python standard
library. cloudpickle is especially useful for cluster computing where
Python expressions are shipped over the network to execute on remote
hosts, possibly close to the data. Among other things, cloudpickle
supports pickling for lambda expressions, functions and classes defined
interactively in the __main__ module.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile dev-requirements.txt
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
# _cloudpickle_testpkg should be actually built and installed
export PYTHONPATH=tests/cloudpickle_testpkg

# file_handles tests fail, TypeError: cannot pickle '_io.FileIO' object
# GH issue: https://github.com/cloudpipe/cloudpickle/issues/114
%pyproject_run_pytest -vra -k "not file_handles"

%files
%doc README.md
%python3_sitelibdir/cloudpickle/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
