%define pypi_name chess

%def_with check

Name:    python3-module-%pypi_name
Version: 1.11.2
Release: alt1

Summary: A chess library for Python
License: GPL-3.0
Group:   Development/Python3
URL:     https://github.com/niklasf/python-chess

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools python3-module-wheel

%if_with check
BuildRequires: stockfish
%endif

Requires: stockfish

BuildArch: noarch

Source: %name-%version.tar
Patch0: %name-%version-alt.patch

%description
A chess library for Python, with move generation and validation,
PGN parsing and writing, Polyglot opening book reading, Gaviota
tablebase probing, Syzygy tablebase probing, and UCI/XBoard engine communication

%prep
%setup
%patch0 -p1

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_check_pyproject

%files
%doc CHANGELOG.rst README.rst LICENSE.txt
%python3_sitelibdir/%pypi_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%changelog
