%define modulename cheroot

%def_enable check
# Nessesary for cherrypy
%def_with tests

Name:    python3-module-%modulename
Version: 10.0.1
Release: alt4

Summary: Cheroot is the high-performance, pure-Python HTTP server used by CherryPy
License: BSD-3-Clause
Group:   Development/Python
URL:     https://pypi.org/project/cheroot
VCS:     https://github.com/cherrypy/cheroot

Source: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools_scm
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-testmon
BuildRequires: python3-module-pytest-cov
BuildRequires: python3-module-pytest-mock
BuildRequires: python3-module-pytest-xdist
BuildRequires: python3-module-pytest-sugar
BuildRequires: python3-module-pytest-watch
BuildRequires: python3-module-jaraco.functools
BuildRequires: python3-module-trustme
BuildRequires: python3-module-requests-unixsocket
BuildRequires: python3-module-urllib3
BuildRequires: python3-module-OpenSSL
%if_enabled check
BuildRequires: python3-module-jaraco.text
BuildRequires: python3-module-jaraco.context
BuildRequires: python3-module-portend
BuildRequires: python3-module-requests_toolbelt
BuildRequires: python3-module-pytest-cov
BuildRequires: python3-module-pytest-rerunfailures
%endif
BuildArch: noarch

%description
Cheroot is the high-performance, pure-Python HTTP server used by CherryPy.

%package tests
Summary: Tests for Cheroot
Group: Development/Python
Requires: %name = %EVR

%description tests
This package contains tests for Cheroot

%prep
%setup
%patch0 -p1

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_install
%if_without tests
rm -rf %python3_sitelibdir/%{modulename}/test
rm -f %python3_sitelibdir/%{modulename}/testing.py
%endif

%check
# see cheroot/test/conftest.py
export HTTP_REQUEST_TIMEOUT=3
%pyproject_run_pytest -vra

%files
%_bindir/cheroot
%python3_sitelibdir/%modulename-%version.dist-info
%python3_sitelibdir/%{modulename}*
%exclude %python3_sitelibdir/%{modulename}/test
%exclude %python3_sitelibdir/%{modulename}/testing.py

%if_with tests
%files tests
%python3_sitelibdir/%{modulename}/test
%python3_sitelibdir/%{modulename}/testing.py
%endif

%changelog
