%define  modulename bitarray

Name:    python3-module-%modulename
Version: 3.7.2
Release: alt1

Summary: Efficient arrays of booleans for Python
License: Python
Group:   Development/Python3
Url:     https://github.com/ilanschnell/bitarray
Vcs:     https://github.com/ilanschnell/bitarray.git

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

Source:  %modulename-%version.tar

%description
This module provides an object type which efficiently represents an array
of booleans.  Bitarrays are sequence types and behave very much like usual
lists.  Eight bits are represented by one byte in a contiguous block of
memory.  The user can select between two representations; little-endian
and big-endian.  All of the functionality is implemented in C.
Methods for accessing the machine representation are provided.
This can be useful when bit level access to binary files is required,
such as portable bitmap image files (.pbm).  Also, when dealing with
compressed data which uses variable bit length encoding, you may find
this module useful.

%prep
%setup -n %modulename-%version

%build
%pyproject_build

%install
%pyproject_install

%check
make test PYTHON=%__python3

%files
%python3_sitelibdir/*
%doc LICENSE *.rst doc/*.rst

%changelog
