%define oname asyncssh

%def_with check

Name: python3-module-%oname
Version: 2.21.1
Release: alt1

Summary: AsyncSSH: Asynchronous SSHv2 client and server library

License: Eclipse Public License v1.0
Group: Development/Python3
URL: https://pypi.org/project/asyncssh
VCS: https://github.com/ronf/asyncssh

Source: %name-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-intro

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-typing-extensions
BuildRequires: python3-module-bcrypt
BuildRequires: python3-module-OpenSSL
BuildRequires: openssl
BuildRequires: openssh-clients
%endif

%py3_provides %oname
%py3_requires asyncio
%py3_use Crypto
%py3_use cryptography >= 2.7

%description
AsyncSSH is a Python package which provides an asynchronous client and
server implementation of the SSHv2 protocol on top of the Python asyncio
framework.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

rm -v %buildroot%python3_sitelibdir/%oname/*_win32*

%check
%pyproject_run_pytest -k 'not test_forward_terminal_size_tty'

%files
%doc COPYRIGHT LICENSE README* examples
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
