%define _unpackaged_files_terminate_build 1
%define pypi_name astroid
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 3.3.11
Release: alt1
Summary: An abstract syntax tree for Python with inference support
License: LGPLv2.1+
Group: Development/Python3
Url: https://pypi.org/project/astroid
Vcs: https://github.com/pylint-dev/astroid
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter contributors-txt
%add_pyproject_deps_check_filter tbump
%pyproject_builddeps_metadata
%pyproject_builddeps_check
# tests/test_manager.py::IsolatedAstroidManagerTest::test_no_user_warning
BuildRequires: python3-module-pip
# tests/test_raw_building.py, filtered by default
BuildRequires: python3-module-mypy
%endif

%description
The aim of this module is to provide a common base representation of python
source code. It is currently the powering pylint's capabilities.

It provides a compatible representation which comes from the _ast module. It
rebuilds the tree generated by the builtin _ast module by recursively walking
down the AST and building an extended ast. The new node classes have additional
methods and attributes for different usages. They include some support for
static inference and local name scopes. Furthermore, astroid can also build
partial trees by inspecting living objects.

%prep
%setup
%patch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile requirements_minimal.txt
%endif

%build
%pyproject_build

%install
%pyproject_install
# used only in tests, but requires Pytest
rm %buildroot%python3_sitelibdir/%mod_name/test_utils.py

%check
%pyproject_run_pytest -vra

%files
%doc ChangeLog README.rst
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
