%define pypi_name apsw
%define sqlite_ver 3.50.4
%def_enable check

Name: python3-module-%pypi_name
Version: 3.50.4.0
Release: alt1

Summary: Another Python SQLite Wrapper
#doc/_sources/copyright.rst.txt
License: Zlib
Group: Development/Python3
Url: https://pypi.org/project/%pypi_name

Vcs: https://rogerbinns.github.io/apsw.git

Source: https://github.com/rogerbinns/%pypi_name/releases/download/%version/%pypi_name-%version.zip

BuildRequires(pre): rpm-build-python3
BuildRequires: unzip libsqlite3-devel >= %sqlite_ver
BuildRequires: python3-devel python3(wheel) python3(setuptools)

%description
APSW is a Python 3 wrapper for the SQLite embedded relational database
engine. In contrast to other wrappers such as pysqlite it focuses on
being a minimal layer over SQLite attempting just to translate the
complete SQLite API into Python.

%prep
%setup -n %pypi_name-%version
find . -name '*.py' | xargs sed -i '1s|^#!python|#!%{__python3}|'

%build
%define opts --enable=load_extension
# error: option --enable not recognized
#%%pyproject_build --backend-config-settings='{"--build-option": ["%opts"]}'
%python3_build %opts

%install
%python3_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
gcc %optflags %optflags_shared -shared -o ./testextension.sqlext -I. -Isqlite3 src/testextension.c
%__python3 -m %pypi_name.tests
#tracer:
#%__python3 -m %pypi_name.trace
#speed tester:
#%__python3 -m %pypi_name.speedtest

%files
%_bindir/%pypi_name
%python3_sitelibdir/*
%doc doc/*

%changelog
