%define _unpackaged_files_terminate_build 1
%define pypi_name anyio

%def_with check

Name: python3-module-anyio
Version: 4.11.0
Release: alt1

Summary: High level compatibility layer for multiple asynchronous event loop implementations
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/anyio
Vcs: https://github.com/agronholm/anyio

BuildArch: noarch

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build

%if_with check
BuildRequires: python3-module-trio-tests
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

# either asyncio or trio
%filter_from_requires /python3(trio.*)/d
# don't add found requires from pytest plugin to requirement list
%add_findreq_skiplist %python3_sitelibdir/%pypi_name/pytest_plugin.py

%description
AnyIO is an asynchronous networking and concurrency library
that works on top of either asyncio or trio.
It implements trio-like structured concurrency (SC) on top of asyncio,
and works in harmony with the native SC of trio itself.

Applications and libraries written against AnyIO's API will run
unmodified on either asyncio or trio.
AnyIO can also be adopted into a library or application incrementally -
bit by bit, no full refactoring necessary.
It will blend in with native libraries of your chosen backend.

%prep
%setup
%autopatch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_depgroup test
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
# tests/test_socket.py:
# Ignore this file since configured DNS and internet are required by most of
# the tests. Another tests are bad itself and can fail accidentally.
%pyproject_run_pytest -Wignore -m "not network" --ignore="tests/test_sockets.py"

%files
%doc README.rst
%python3_sitelibdir/%pypi_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%changelog
