%define _unpackaged_files_terminate_build 1
%define pypi_name aiohttp-jinja2
%define mod_name aiohttp_jinja2

%def_with check

Name: python3-module-%mod_name
Epoch: 1
Version: 1.6
Release: alt1
Summary: jinja2 template renderer for aiohttp.web
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/aiohttp-jinja2/
VCS: https://github.com/aio-libs/aiohttp_jinja2.git
Source0: aiohttp-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
# dependencies=
BuildRequires: python3(aiohttp)
BuildRequires: python3(jinja2)

BuildRequires: python3(aiohttp.test_utils)
BuildRequires: python3(pytest)
BuildRequires: python3(pytest_aiohttp)
BuildRequires: python3(yarl)
%endif

# well-known PyPI name
%py3_provides %pypi_name
Provides: python3-module-%pypi_name = %EVR

%description
jinja2 template renderer for aiohttp.web.

%prep
%setup -n aiohttp-%version

# drop dependency on coverage
sed -i '/--cov=/d' pytest.ini

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -ra tests

%files
%doc *.rst docs/*.rst
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
