%define _unpackaged_files_terminate_build 1
%define pypi_name aiohttp
%define mod_name %pypi_name
%def_with check

%define add_python_extra() \
%{expand:%%package -n %%name+%1 \
Summary: %%summary \
Group: Development/Python3 \
Requires: %%name \
%%pyproject_runtimedeps_metadata_extra %1 \
%%description -n %%name+%1' \
Extra "%1" for %%pypi_name. \
%%files -n %%name+%1 \
}

Name: python3-module-%pypi_name
Version: 3.13.2
Release: alt1

Summary: http client/server for asyncio
License: Apache-2.0
Group: Development/Python
Url: https://pypi.org/project/aiohttp/
Vcs: https://github.com/aio-libs/aiohttp

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
BuildRequires: python3-module-cython
BuildRequires: libllhttp-devel
%if_with check
# not packaged yet
%add_pyproject_deps_check_filter python-on-whales
%add_pyproject_deps_check_filter setuptools-git
%add_pyproject_deps_check_filter wait-for-it
%pyproject_builddeps_metadata_extra speedups
%pyproject_builddeps_check
# remove when fixed: https://github.com/aio-libs/aiohttp/pull/11638
BuildRequires: python3-module-packaging
%endif

%package tests
Summary: Tests for aiohttp
Group: Development/Python
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
Requires: python3-module-aiohttp = %EVR

%add_python_extra speedups

%description
http client/server for asyncio (PEP-3156).

%description tests
http client/server for asyncio (PEP-3156).
This package contains tests for aiohttp

%prep
%setup
%autopatch -p1
%python3_fix_shebang .
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
cat requirements/base.in requirements/test-common.in >> requirements/test.in
%pyproject_deps_resync_check_pipreqfile requirements/test.in
%endif

%build
# link with system libllhttp
export AIOHTTP_USE_SYSTEM_DEPS=1
rm -r vendor/llhttp/
make cythonize-nodeps
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- pytest -m 'not dev_mode and not internal' \
	-vra -o=addopts='' \
	-n auto \
	--ignore=tests/autobahn \
	--ignore=tests/test_proxy_functional.py \
	--ignore-glob='tests/test_benchmarks_*' \
	tests \
%ifarch ppc64le
	||:
%endif

%files
%doc README.*
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}
%exclude %python3_sitelibdir/%mod_name/*test*
%exclude %python3_sitelibdir/%mod_name/*/*test*

%files tests
%python3_sitelibdir/%mod_name/*test*
%python3_sitelibdir/%mod_name/*/*test*

%changelog
