%define oname SimPy
%define major 3.0

Name: python3-module-%oname
Version: %major.11
Release: alt1

Summary: SimPy simulation package
License: LGPL
Group: Development/Python3
Url: http://simpy.sourceforge.net/
BuildArch: noarch

Source: http://sourceforge.net/projects/simpy/files/simpy/SimPy-%major/%oname-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools


%description
SimPy is a process-based discrete-event simulation language
based on standard Python and released under the GNU LGPL.

It provides the modeller with components of a simulation
model. These include processes, for active components like
customers, messages, and vehicles, and resources, for
passive components that form limited capacity congestion
points like servers, checkout counters, and tunnels. It
also provides monitor variables to aid in gathering
statistics. SimPy comes with extensive plotting capabilities.

The distribution contains in-depth documentation, tutorials,
and a large number of simulation models.

Simulation model developers are encouraged to share their
SimPy modeling techniques with the SimPy community. Please
post a message to the simpy-Users mailing list,

%prep
%setup -n %oname-%version

%build
%python3_build

%install
%python3_install

%files
%doc CHANGES.txt AUTHORS.txt LICENSE.txt README.txt
%python3_sitelibdir/*


%changelog
