%define rname reportlab
%define oname Reportlab

%def_with check

Name: python3-module-%oname
Version: 4.4.3
Release: alt1

Summary: The Reportlab Toolkit

License: BSD license (see LICENSE.txt for details)
Group: Development/Python3
Url: https://pypi.org/project/reportlab

Source: reportlab-%version.tar

BuildRequires(pre): rpm-macros-sphinx3
BuildRequires(pre): rpm-build-python3

BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

BuildRequires: python3-module-sphinx
BuildRequires: libfreetype-devel

%if_with check
BuildRequires: python3-module-Pillow
BuildRequires: python3-module-chardet
%endif

BuildArch: noarch

%description
The ReportLab Toolkit.
An Open Source Python library for generating PDFs and graphics.

%package docs
Summary: Documentation for Reportlab Toolkit
Group: Development/Documentation
BuildArch: noarch

%description docs
The ReportLab Toolkit.
An Open Source Python library for generating PDFs and graphics.

This package contains documentation for Reportlab Toolkit.

%prep
%setup -n reportlab-%version

%build
%pyproject_build

%make -C docs html SPHINXBUILD=sphinx-build-3

%install
%pyproject_install

%check
pushd tests
python3 runAll.py
popd

%files
%doc *.txt
%python3_sitelibdir/%rname
%python3_sitelibdir/%rname-%version.dist-info

%files docs
%doc docs/build/html docs/userguide demos

%changelog
