%define _unpackaged_files_terminate_build 1
%define pypi_name Pygments

%def_with check

Name: python3-module-Pygments
Version: 2.19.2
Release: alt1
Summary: Pygments is a syntax highlighting package written in Python
License: BSD-2-Clause
Group: Development/Python3
Url: https://pygments.org/
VCS: https://github.com/pygments/pygments.git
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
# PEP503 normalized name
Provides: python3-module-pygments = %EVR
# PyPI well known name
%py3_provides %pypi_name
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter wcag-contrast-ratio
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
It is a generic syntax highlighter for general use in all kinds of
software such as forum systems, wikis or other applications that need
to prettify source code. Highlights are:
 * a wide range of common languages and markup formats is supported
 * special attention is paid to details, increasing quality by a fair amount
 * support for new languages and formats are added easily
 * a number of output formats, presently HTML, LaTeX, RTF, SVG and ANSI sequences
 * it is usable as a command-line tool and as a library

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_tox tox.ini testenv
%endif

%build
%pyproject_build

%install
%pyproject_install
mv %buildroot%_bindir/pygmentize %buildroot%_bindir/pygmentize3
ln -s pygmentize3 %buildroot%_bindir/pygmentize.py3

# only for build pygments doc
rm -fv %buildroot%python3_sitelibdir/pygments/sphinxext.py

%check
%pyproject_run_pytest -vra

%files
%_bindir/pygmentize3
%_bindir/pygmentize.py3
%python3_sitelibdir/pygments/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%changelog
