%define _unpackaged_files_terminate_build 1
%define pypi_name BTrees
%define mod_name %pypi_name

%define dynamic_mods %(echo `cat %SOURCE2 2>/dev/null || echo unknown`)

%def_with check

Name: python3-module-%pypi_name
Version: 6.2
Release: alt1
Summary: Scalable persistent object containers
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/BTrees/
Vcs: https://github.com/zopefoundation/BTrees.git
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Source2: dynamic_mods.list
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
%py3_provides %dynamic_mods
BuildRequires(pre): rpm-build-pyproject
BuildRequires: python3-module-persistent-devel
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra test
%endif

%description
This package contains a set of persistent object containers built around
a modified BTree data structure. The trees are optimized for use inside ZODB's
"optimistic concurrency" paradigm, and include explicit resolution of
conflicts detected by that mechanism.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

# make sure we provide actual names
# these names are generated at runtime, see src/BTrees/__init__.py for details
%pyproject_run -- python - <<-'ENDRUN'
from pathlib import Path
import BTrees

Path("mods.actual.list").write_text(
    "\n".join(sorted([f'BTrees.{n}BTree' for n in BTrees._FAMILIES])) + "\n",
    encoding="utf-8",
)
ENDRUN

sort %SOURCE2 > mods.expected.list
diff -y mods.expected.list mods.actual.list || {
    echo 'Update expected list of mods: %SOURCE2' ;
    exit 1 ;
}

%install
%pyproject_install

# don't ship sources for C extensions
rm %buildroot%python3_sitelibdir/%pypi_name/*.{h,c}

%check
%pyproject_run -- zope-testrunner --test-path=src -vv

%files
%doc README.*
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/%mod_name/tests

%changelog
