%def_enable snapshot

%define modname ethtool
%def_without man

Name: python-module-%modname
Version: 0.14
Release: alt2

Summary: Ethernet settings python bindings
Group: Development/Python
License: GPL-2.0-only
Url: https://pypi.python.org/pypi/%modname/

%if_disabled snapshot
Source: https://pypi.io/packages/source/e/%modname/%modname-%version.tar.gz
%else
Vcs: https://github.com/fedora-python/python-ethtool
Source: python-%modname-%version.tar
%endif

BuildRequires(pre): rpm-build-python
BuildRequires: python-devel python-module-setuptools libnl-devel
%{?_with_man:BuildRequires: asciidoc-a2x >= 8.6.8}

%description
Python bindings for the ethtool kernel interface, that allows querying
and changing of Ethernet card settings, such as speed, port,
auto-negotiation, and PCI locations.

%prep
%setup -n %{?_enable_snapshot:python-}%modname-%version

%build
%python_build
%if_with man
a2x -d manpage -f manpage man/pethtool.8.asciidoc
a2x -d manpage -f manpage man/pifconfig.8.asciidoc
%endif

%install
%python_install --install-scripts=%_sbindir

# rename binaries
for f in %buildroot%_sbindir/{pethtool,pifconfig}; do
mv -f $f $f.py; done

%if_with man
mkdir -p %buildroot%_man8dir
install -m644 man/pethtool.8 %buildroot%_man8dir/pethtool.8
install -m644 man/pifconfig.8 %buildroot%_man8dir/pifconfig.8
%endif

%files
%_sbindir/pethtool.py
%_sbindir/pifconfig.py
%python_sitelibdir/ethtool.so
%python_sitelibdir/*.egg-info
%{?_with_man:%_man8dir/*}
%doc README.rst CHANGES.rst

%changelog
