%global _unpackaged_files_terminate_build 1
%add_findreq_skiplist %perl_vendor_privlib/PVE/ExtMetric.pm
%add_findreq_skiplist %perl_vendor_privlib/PVE/Status/InfluxDB.pm
%add_findreq_skiplist %perl_vendor_privlib/PVE/Jobs.pm

%define ver_major 9.0
%define ver_minor 6
Name: pve-manager
Summary: The Proxmox Virtual Environment
Version: %ver_major.%ver_minor
Release: alt2
License: AGPL-3.0+ and GPLv3 and MIT and OFL-1.1
Group: System/Servers
Url: https://git.proxmox.com/
Vcs: git://git.proxmox.com/git/pve-manager.git

ExclusiveArch: x86_64 aarch64

BuildRequires(pre): rpm-macros-systemd
BuildRequires(pre): rpm-macros-javascript

Requires: cstream lzop zstd wget schedutils gdisk hdparm rsync pciutils
Requires: perl-LWP-Protocol-https
Requires: pve-common >= 9.0.8 pve-guest-common >= 5.1.4
Requires: pve-storage >= 9.0.5 pve-cluster >= 9.0.1
Requires: pve-vncterm pve-novnc >= 1.2.2 pve-spiceterm pve-xtermjs >= 4.7.1 pve-acme
Requires: pve-container >= 5.2.5 pve-firewall pve-ha-manager >= 5.0.3 pve-qemu-server >= 9.0.10 pve-i18n >= 3.2.0 pve-docs
Requires: proxmox-widget-toolkit >= 5.0.2 proxmox-mini-journalreader >= 1.3.1 proxmox-rrd-migration-tool >= 1.0.0
Requires: fonts-font-awesome fonts-otf-fontawesome fonts-font-logos javascript-extjs javascript-qrcodejs
Requires: libproxmox-rs-perl >= 0.4 libpve-rs-perl >= 0.10.4
Requires: perl-Net-SSLeay perl-Term-ReadLine-Gnu
Requires: librados2-perl >= 1.3.1
Requires: sequoia-sqv

Source: %name-%version.tar
Source2: 50-pve.preset
Source6: basealt_logo.png
Source8: basealt_favicon.ico
Source9: basealt_logo-128.png

Source10: sencha-touch.tgz

BuildRequires: pve-doc-generator >= 9.0.5 xmlto perl-Pod-Parser
BuildRequires: pve-storage >= 8.3.5 pve-cluster >= 8.0.5
BuildRequires: pve-common >= 9.0.4 pve-guest-common >= 5.1.4
BuildRequires: libpve-cluster-perl >= 6.1.6 libpve-cluster-api-perl >= 7.0.5 pve-container >= 5.1.1 pve-qemu-server >= 9.0.10,
BuildRequires: pve-acme pve-http-server >= 6.0.3 pve-access-control >= 9.0.3
BuildRequires: proxmox-widget-toolkit >= 4.3.0
BuildRequires: perl(AptPkg/Cache.pm) perl(File/ReadBackwards.pm) perl(Template.pm) perl(Net/DNS/Resolver.pm)
BuildRequires: unzip gnupg
BuildRequires: update-kernel

%description
This package contains the PVE management tools

%prep
%setup
# sencha-touch
tar xf %SOURCE10

grep '/var/run' * -rl | while read f; do
    sed -i 's|/var/run|/run|' $f
done
sed -i 's|}/lib/systemd/|}%_systemddir/|' defines.mk

%build
%make PACKAGE="pve-manager" VERSION="%ver_major-%ver_minor" PVERELEASE="%ver_major" REPOID="%release"

%install
%makeinstall_std

install -m0644 %SOURCE6 %buildroot%_datadir/%name/images/basealt_logo.png
install -m0644 %SOURCE8 %buildroot%_datadir/%name/images/favicon.ico
install -m0644 %SOURCE9 %buildroot%_datadir/%name/images/logo-128.png

# sencha-touch
mkdir -p %buildroot%_jsdir/
cp -p -r sencha-touch %buildroot%_jsdir/

# fix config backup job retention
mkdir -p %buildroot%_localstatedir/%name/jobs

mkdir -p %buildroot%_localstatedir/%name/apl-info

mkdir -p %buildroot%_tmpfilesdir
cat << __EOF__ > %buildroot%_tmpfilesdir/%name.conf
d /run/pveproxy 0700 www-data www-data -
f /var/lock/pveproxy.lck 0644 www-data www-data
f /var/lock/spiceproxy.lck 0644 www-data www-data
__EOF__

# Enable autostart pvenetcommit.service
mkdir -p %buildroot%_unitdir/sysinit.target.wants
ln -r -s %buildroot%_unitdir/pvenetcommit.service %buildroot%_unitdir/sysinit.target.wants

# Install systemd preset
mkdir -p %buildroot%_presetdir
install -m 0644 %SOURCE2 %buildroot%_presetdir/50-pve.preset

# Cleanup
rm -rf %buildroot%_sysconfdir/apt
rm -rf %buildroot%_sysconfdir/initramfs-tools
#rm -f  %buildroot%_sysconfdir/modprobe.d/pve-blacklist.conf
rm -rf %buildroot%_sysconfdir/network
#rm -f  %buildroot%_unitdir/pve-daily-update.service
#rm -f  %buildroot%_unitdir/pve-daily-update.timer
rm -f  %buildroot%_unitdir/pvebanner.service
#rm -f  %buildroot%_unitdir/pvenetcommit.service
rm -f  %buildroot%_bindir/pvebanner
rm -f  %buildroot%_bindir/pvesubscription
#rm -f  %buildroot%_bindir/pveupgrade
#rm -f  %buildroot%_datadir/doc/pve-manager/aplinfo.dat
rm -f  %buildroot%_man1dir/pvesubscription.1*
#rm -f  %buildroot%_man1dir/pveupgrade.1*
rm -f  %buildroot%_man1dir/pve6to7.1*
rm -f  %buildroot%_bindir/pve6to7
rm -f  %buildroot%_bindir/pve7to8
rm -f  %buildroot%_man1dir/pve7to8.1*

%post
%post_systemd_postponed pvedaemon.service pvestatd.service pveproxy.service spiceproxy.service pvescheduler.service pve-daily-update.timer

if test ! -e /var/lib/pve-manager/apl-info/download.proxmox.com; then
    mkdir -p /var/lib/pve-manager/apl-info
    cp /usr/share/doc/pve-manager/aplinfo.dat /var/lib/pve-manager/apl-info/download.proxmox.com
    pveam update ||:
fi

%triggerun -- %name < 9.0.0
if [ $2 -gt 0 ]; then
    # PVE 8 to 9 upgrade
    printf '\n\nNOTE: Migrating existing RRD metrics data from nodes, storages and virtual guests to new PVE format version - this can take some time!\n\n'
    /usr/libexec/proxmox/proxmox-rrd-migration-tool --migrate || \
        echo "migration failed, see output above for errors and try to migrate existing data manually by running '/usr/libexec/proxmox/proxmox-rrd-migration-tool --migrate'"

    if test -e /etc/lvm/lvm.conf && grep "^\s*thin_check_options" /etc/lvm/lvm.conf | grep -qv -- "--clear-needs-check-flag"; then
        printf '\nNOTE: Detected override for 'thin_check_options' without '--clear-needs-check-flag' option in /etc/lvm/lvm.conf\n'
        printf 'Add the option to the override or thin pools with minor issues might not automatically activate anymore!\n\n'
    fi
fi

%preun
%preun_systemd pvedaemon.service pvestatd.service pveproxy.service spiceproxy.service pvescheduler.service pve-daily-update.timer

%files
%doc debian/copyright
%_datadir/doc/%name
%_datadir/bash-completion/completions/*
%_datadir/zsh/vendor-completions/*
%_sysconfdir/logrotate.d/pve
%config(noreplace) %_sysconfdir/vzdump.conf
%_unitdir/*.service
%_unitdir/*.timer
%_unitdir/*.target
%_unitdir/ceph-*.service.d/*
%_unitdir/sysinit.target.wants/*
%_presetdir/50-pve.preset
%_systemd_dir/network/99-default.link.d/proxmox-mac-address-policy.conf
%config %_sysconfdir/modprobe.d/pve-blacklist.conf
%_tmpfilesdir/%name.conf
%_bindir/*
%perl_vendor_privlib/PVE/*.pm
%perl_vendor_privlib/PVE/API2/*.pm
%perl_vendor_privlib/PVE/API2/Hardware
%perl_vendor_privlib/PVE/API2/Ceph
%perl_vendor_privlib/PVE/API2/Cluster
%perl_vendor_privlib/PVE/CLI/*.pm
%perl_vendor_privlib/PVE/Ceph
%perl_vendor_privlib/PVE/Jobs
%perl_vendor_privlib/PVE/Service
%perl_vendor_privlib/PVE/Status
%_datadir/%name
%_localstatedir/%name
%_localstatedir/vz
%attr(0770,root,www-data) %_logdir/pveproxy
%_man1dir/*
%_man8dir/*
%_jsdir/sencha-touch

%changelog
