%define _unpackaged_files_terminate_build 1
%define xdg_name com.vysp3r.ProtonPlus

%def_without check

Name: protonplus
Version: 0.5.13
Release: alt1

Summary: Simple and powerful manager for Wine, Proton, DXVK and VKD3D
License: GPL-3.0
Group: Games/Other

Url: https://github.com/Vysp3r/ProtonPlus
# Source-url: https://github.com/Vysp3r/ProtonPlus/archive/refs/tags/v%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala
BuildRequires: /proc

BuildRequires: pkgconfig(gee-0.8)
BuildRequires: pkgconfig(gtk4)
BuildRequires: pkgconfig(json-glib-1.0)
BuildRequires: pkgconfig(libadwaita-1) >= 1.4
BuildRequires: pkgconfig(libarchive)
BuildRequires: pkgconfig(libsoup-3.0)

%{?!_without_check:%{?!_disable_check:BuildRequires: %_bindir/appstream-util %_bindir/desktop-file-validate}}

%description
ProtonPlus is a simple and powerful manager for:
 - Wine
 - Proton
 - DXVK
 - VKD3D
 - Several other runners

Supports Steam, Lutris, Heroic and Bottles.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
%find_lang %xdg_name

%check
%__meson_test

%files -f %xdg_name.lang
%doc LICENSE.md
%doc README.md CONTRIBUTING.md CODE_OF_CONDUCT.md SECURITY.md
%_bindir/%name
%_datadir/metainfo/%xdg_name.metainfo.xml
%_desktopdir/%xdg_name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/*/apps/%xdg_name.png

%changelog
