%define soversion 1
%define optflags_lto %nil

Name: protobuf-c
Version: 1.5.2
Release: alt1
Summary: Google's Protocol Buffers implementation in C

Group: System/Libraries
License: BSD-3-Clause
Url: https://github.com/protobuf-c/protobuf-c

Source: %name-%version.tar

BuildRequires: gcc-c++
BuildRequires: libprotobuf-devel >= 2.6.0 protobuf-compiler

%description
Protocol Buffers are a way of encoding structured data in an efficient yet
extensible format. This package provides a code generator and run-time
libraries to use Protocol Buffers from pure C (not C++).

It uses a modified version of protoc called protoc-c.

%package compiler
Summary: Protocol Buffers Compiler
Group: Development/Other
Requires: lib%{name}%{soversion} = %version-%release

%description compiler
Compiler for protocol buffer definition files.

%package -n lib%{name}%{soversion}
Summary: Protocol Buffer C library.
Group: System/Libraries
Provides: lib%{name} = %version-%release

%description -n lib%{name}%{soversion}
Protocol Buffers are a way of encoding structured data in
an efficient yet extensible format. Google uses Protocol Buffers for
almost all of its internal RPC protocols and file formats.

%package -n lib%{name}-devel
Summary: Development files for %name
Group: Development/C
Requires: lib%{name}%{soversion} = %version-%release

%description -n lib%{name}-devel
This package contains development files required for packaging
%name.

%prep
%setup -q

%build
%autoreconf
%configure --disable-static
# protoc -I. fails to import google/protobuf/descriptor.proto from /usr/include
ln -s /usr/include/google google
%make_build

%check
%make check

%install
%makeinstall_std

%files compiler
%_bindir/protoc-c
%_bindir/protoc-gen-c

%files -n lib%{name}%{soversion}
%_libdir/*.so.*

%files -n lib%{name}-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%doc TODO CHANGELOG.md README.md LICENSE

%changelog
