%global import_path github.com/kafka_exporter
%define mod kafka_exporter

Name:    prometheus-kafka_exporter
Version: 1.9.0
Release: alt3

Summary: Kafka exporter for Prometheus
License: Apache-2.0
Group:   Other
Url:     https://github.com/danielqsj/kafka_exporter

Source: %mod-%version.tar
Source1: vendor.tar
Source2: %name.sysconfig
Source3: %name.service

BuildRequires(pre): rpm-build-golang
BuildRequires: golang

Requires(pre): prometheus-common

%description
Kafka exporter for Prometheus. For other metrics from Kafka, have a look at the
JMX exporter.

%prep
%setup -n %mod-%version
tar xf %SOURCE1

%build
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"

%golang_prepare
export LDFLAGS="-X github.com/prometheus/common/version.Version=%version \
         -X github.com/prometheus/common/version.Revision=%release \
         -X github.com/prometheus/common/version.Branch=tarball \
         -X github.com/prometheus/common/version.BuildDate=$(date -u +%%Y%%m%%d)"

cd .build/src/%import_path
%golang_build .

%install
export BUILDDIR="$PWD/.build"
export IGNORE_SOURCES=1

%golang_install
install -Dm0644 %SOURCE2 %buildroot%_sysconfdir/sysconfig/%name
install -Dm0644 %SOURCE3 %buildroot%_unitdir/%name.service
mkdir -p %buildroot%_sharedstatedir/prometheus/kafka-exporter

%post
%post_service %name

%preun
%preun_service %name

%files
%doc *.md
%_bindir/*
%_unitdir/%name.*
%dir %attr(0775,root,prometheus) %_sharedstatedir/prometheus/kafka-exporter
%config(noreplace) %_sysconfdir/sysconfig/%name

%changelog
