%define _unpackaged_files_terminate_build 1
%def_disable static
%def_enable systemd
%def_enable cbcp
%def_enable microsoft-extensions
%def_enable multilink
%def_with atm
%def_with pam
%def_with pcap

Name: ppp
Version: 2.5.2
Release: alt2

Summary: The PPP daemon and documentation
License: BSD-3-Clause AND LGPL-2.1-or-later AND GPL-2.0-or-later
Group: Networking/Other

Url: https://ppp.samba.org

Source0: %name-%version.tar
Source2: ppp.pamd
Source4: ppp.control
Source5: ppp.logrotate
Source6: ppp.tmpfiles
Source7: 95-ppp.rules

Patch1: %name-%version-%release.patch

BuildRequires: libssl-devel perl-IPC-Signal perl-Proc-Daemon perl-Proc-WaitStat
%{?_with_pam:BuildRequires: libpam-devel}
%{?_with_pcap:BuildRequires: libpcap-devel}
%{?_with_atm:BuildRequires: libatm-devel}
%{?_enable_systemd:BuildRequires: libsystemd-devel}
Requires: ppp-common
Requires: kmod >= 14
Requires: udev >= 204-alt2

%add_findprov_lib_path %_libdir/pppd/%version

%package devel
Summary: Header files needed for building extra pppd plugins
Group: Development/C
Requires: %name = %version-%release

%package radius
Summary: RADIUS authentication plugin for pppd
Group: System/Servers
Requires: %name = %version-%release

%package pppoatm
Summary: PPP over ATM plugin for pppd
Group: System/Servers
Requires: %name = %version-%release


%package pppoe
Summary: PPP over ethernet plugin for pppd
Group: System/Servers
Requires: %name = %version-%release

%description
The %name package contains the PPP (Point-to-Point Protocol) daemon
and documentation for PPP support.  The PPP protocol provides a
method for transmitting datagrams over serial point-to-point links.

The %name package should be installed if your machine need to support
the PPP protocol.

%description devel
Header files needed for building extra pppd plugins.

%description radius
The Remote Authentication Dial In User Service (RADIUS) plugin for pppd
permits pppd to perform PAP, CHAP, MS-CHAP and MS-CHAPv2 authentication
against a RADIUS server instead of the usual /etc/ppp/pap-secrets and
/etc/ppp/chap-secrets files.

%description pppoatm
PPP over ATM plugin for pppd.

%description pppoe
PPP over ethernet plugin for pppd.

%prep
%setup
%patch1 -p1

#set the right paths in radiusclient.conf
sed -i -e "s|/usr/local/etc|%_sysconfdir|" \
	     -e "s|/usr/local/sbin|%_sbindir|" pppd/plugins/radius/etc/radiusclient.conf
#set config dir to /etc/ppp/radius
sed -i -e "s|/etc/radiusclient|/etc/ppp/radius|g" \
		pppd/plugins/radius/{*.8,*.c,*.h} \
		pppd/plugins/radius/etc/*


%build
%autoreconf
%configure \
    %{subst_enable static} \
    %{subst_enable systemd} \
    %{subst_enable cbcp} \
    %{?_enable_microsoft_extensions:--enable-microsoft-extensions} \
    %{subst_enable multilink} \
    --runstatedir=/run \
    --localstatedir=%_var \
    --with-runtime-dir=/run/%name \
    --with-logfile-dir=%_logdir/%name \
    --with-system-ca-path="/etc/pki/tls/certs" \
    %{subst_with atm} \
    %{subst_with pam} \
    %{subst_with pcap} \
    %nil

%make_build

%install
%makeinstall_std
for f in %buildroot%_sysconfdir/%name/*.example; do
        mv "$f" "${f%%.*}"
done

for f in `find scripts/ sample/ -type f`; do
	chmod 644 "$f"
	if grep -F -qs /usr/local/bin/ "$f"; then
		subst -p 's|/usr/local/bin|%_bindir|g' "$f"
	fi
	if file -b "$f" |grep -F -qs 'shell script'; then
		chmod a+x "$f"
	fi
done

install -pDm640 %SOURCE2 %buildroot%_sysconfdir/pam.d/%name

mkdir -p %buildroot%_sysconfdir/%name/peers
mkdir -p %buildroot%_sysconfdir/%name/radius
cp -a pppd/plugins/radius/etc/* %buildroot%_sysconfdir/%name/radius/

install -pDm755 %SOURCE4 %buildroot%_controldir/%name

mkdir -p %buildroot%_logdir/%name
touch %buildroot%_logdir/%name/connect-errors

install -pDm644 %SOURCE6 %buildroot/%_tmpfilesdir/%name.conf
install -pDm644 %SOURCE7 %buildroot/%_udevrulesdir/95-%name.rules

# Logrotate script
install -pDm644 %SOURCE5 %buildroot%_sysconfdir/logrotate.d/%name

%pre
%pre_control %name

%post
%post_control -s traditional %name
%tmpfiles_create %name.conf

%files
%attr(711,root,root) %_sbindir/*
%exclude %_sbindir/pppoe-discovery
%attr(700,root,root) %dir %_logdir/%name
%attr(755,root,root) %dir %_sysconfdir/%name
%attr(711,root,root) %dir %_sysconfdir/%name/peers
%attr(600,root,root) %config(noreplace) %_sysconfdir/%name/*-secrets
%attr(600,root,root) %config(noreplace) %_sysconfdir/%name/eaptls-*
%attr(600,root,root) %config(noreplace) %_sysconfdir/%name/openssl*
%attr(644,root,root) %config(noreplace) %_sysconfdir/%name/options
%config(noreplace) %_sysconfdir/logrotate.d/%name
%config(noreplace) %_sysconfdir/pam.d/%name
%_tmpfilesdir/%name.conf
%_udevrulesdir/95-%name.rules
%config %_controldir/%name
%_libdir/pppd
%exclude %_libdir/pppd/*/*.la
%_logdir/%name/*
%{?_with_atm:%exclude %_libdir/pppd/%version/pppoatm.so}
%exclude %_libdir/pppd/%version/pppoe.so
%exclude %_libdir/pppd/%version/rad*
%_man8dir/*.8*
%exclude %_man8dir/*rad*
%exclude %_man8dir/pppoe-discovery*
%doc PLUGINS SETUP FAQ README* scripts sample

%files devel
%_includedir/pppd
%_pkgconfigdir/pppd.pc

%if_with atm
%files pppoatm
%_libdir/pppd/%version/pppoatm.so
%endif

%files pppoe
%_libdir/pppd/%version/pppoe.so
%attr(755,root,root) %_sbindir/pppoe-discovery
%_man8dir/pppoe-discovery*

%files radius
%_libdir/pppd/%version/rad*.so
%_man8dir/*rad*
%config(noreplace) %_sysconfdir/%name/radius/

%changelog
