%define pg_ver 16
# Use JIT
%def_with jit

Name: postgresql%pg_ver-plv8
Version: 3.2.4
Release: alt1

Summary: PLV8 - A Procedural Language in Javascript powered by V8
License: PostgreSQL
Group: Databases
Url: https://github.com/plv8/plv8

Source: %name-%version.tar
Source101: v8-cmake.tar
Patch0: %name-%version-%release.patch

BuildRequires: lld19.1-devel llvm19.1-devel clang19.1-devel cmake /proc
BuildRequires: postgresql%pg_ver-server-devel
Requires: postgresql%pg_ver-server

ExcludeArch: %e2k %ix86 loongarch64

%description
PLV8 is a shared library that provides a PostgreSQL procedural language powered
by V8 Javascript Engine. With this program you can write in Javascript your
function that is callable from SQL.

%prep
%setup
tar -xf %SOURCE101 -C deps/v8-cmake
%patch0 -p1

%build
%make CC=clang-19 CXX=clang++-19 LLVM_CONFIG=/usr/bin/llvm-config-19

%install
%makeinstall_std

%files
%doc docs/*
%_libdir/pgsql/plv8-*.so
%if_with jit
%_libdir/pgsql/bitcode/*
%endif
%_datadir/pgsql/extension/*

%changelog
