%define pg_ver 13
%define prog_name pgpool-II
%define sname pgpool
%ifnarch %e2k
%set_gcc_version      13
%endif

Name: postgresql%pg_ver-%prog_name
Version: 4.6.3
Release: alt1
Summary: Pgpool is a connection pooling/replication server for PostgreSQL
License: BSD
Group: Databases
# Source git://git.postgresql.org/git/pgpool2.git
Url: http://www.pgpool.net
Source: %prog_name-%version.tar
Source1: pgpool.service
Source2: pgpool.tmpfiles
Source3: pgpool.init
Source4: pgpool.sysconfig
Patch0: 0001-Update-path-for-socket-and-log.patch
Patch1: 0002-pgpool-II-4.6.3-fix-build-doc.patch

BuildRequires: OpenSP
BuildRequires: docbook-style-dsssl
BuildRequires: docbook-style-dsssl-utils
BuildRequires: docbook-style-xsl
BuildRequires: perl-parent
BuildRequires: xsltproc
#BuildRequires: libfreetds-devel
BuildRequires: flex
BuildRequires: postgresql%pg_ver-server-devel
BuildRequires: libpam-devel
BuildRequires: libmemcached-devel
BuildRequires: libssl-devel

Provides: pgpool2 = %EVR
Conflicts: pgpool2 < %EVR
Requires: postgresql%pg_ver-server
%add_findprov_skiplist %_libdir/libpcp.so*
%filter_from_requires /^libpcp\.so.*/d

%description
pgpool-II is a inherited project of pgpool (to classify from
pgpool-II, it is sometimes called as pgpool-I). For those of
you not familiar with pgpool-I, it is a multi-functional
middle ware for PostgreSQL that features connection pooling,
replication and load balancing functions. pgpool-I allows a
user to connect at most two PostgreSQL servers for higher
availability or for higher search performance compared to a
single PostgreSQL server.

Postgresql extensions libraries and sql files for pgpool-II.

%prep
%setup -n %prog_name-%version
%patch0 -p1
%patch1 -p1

%build
export CC=%__cc
export CXX=%__cxx

%autoreconf
%configure \
    --disable-static \
    --with-pam \
    --with-openssl \
    --disable-rpath \
    --with-memcached=%_includedir/libmemcached \
    --sysconfdir=%_sysconfdir/%sname

%make_build -j1
%make_build -C src/sql/pgpool-recovery
%make_build -C src/sql/pgpool-regclass
%make_build -C doc all

%install
%make DESTDIR=%buildroot install
%make DESTDIR=%buildroot install -C src/sql/pgpool-recovery
%make DESTDIR=%buildroot install -C src/sql/pgpool-regclass

mkdir -p %buildroot{{%_logdir,%_datadir}/%sname,%_unitdir,%_initdir,%_tmpfilesdir,%_man1dir,%_man8dir}

install -p -m644 %SOURCE1 %buildroot%_unitdir/%sname.service
install -p -m644 %SOURCE2 %buildroot%_tmpfilesdir/%sname.conf
install -p -m755 %SOURCE3 %buildroot%_initdir/%sname
install -p -m644 -D %SOURCE4 %buildroot%_sysconfdir/sysconfig/%sname

mv %buildroot%_sysconfdir/%sname/pcp.conf.sample %buildroot%_sysconfdir/%sname/pcp.conf
mv %buildroot%_sysconfdir/%sname/pgpool.conf.sample %buildroot%_sysconfdir/%sname/pgpool.conf
mv %buildroot%_sysconfdir/%sname/pool_hba.conf.sample  %buildroot%_sysconfdir/%sname/pool_hba.conf
mv %buildroot%_sysconfdir/%sname/failover.sh.sample %buildroot%_sysconfdir/%sname/failover.sh
mv %buildroot%_sysconfdir/%sname/follow_primary.sh.sample %buildroot%_sysconfdir/%sname/follow_primary.sh
mv %buildroot%_sysconfdir/%sname/pgpool_remote_start.sample %buildroot%_sysconfdir/%sname/pgpool_remote_start
mv %buildroot%_sysconfdir/%sname/recovery_1st_stage.sample %buildroot%_sysconfdir/%sname/recovery_1st_stage

cp doc/src/sgml/man1/* %buildroot%_man1dir/
cp doc/src/sgml/man8/* %buildroot%_man8dir/

rm -f %buildroot%_libdir/*.{a,la}

%post
# Migrate configs from pgpool < 4.2.1
if [ $1 -eq 2 ]; then
    [ ! -f %_sysconfdir/pcp.conf ] || mv -f %_sysconfdir/pcp.conf %_sysconfdir/%sname/pcp.conf
    [ ! -f %_sysconfdir/pgpool.conf ] || mv -f %_sysconfdir/pgpool.conf %_sysconfdir/%sname/pgpool.conf
    [ ! -f %_sysconfdir/pool_hba.conf ] || mv -f %_sysconfdir/pool_hba.conf %_sysconfdir/%sname/pool_hba.conf
    chown root:postgres %_sysconfdir/%sname/*
    chmod 640 %_sysconfdir/%sname/*
fi
%post_service %sname

%preun
%preun_service %sname

%files
%doc NEWS COPYING src/sample doc/src/sgml/html
%dir %attr(750,root,postgres) %_sysconfdir/%sname
%config(noreplace) %attr(640,root,postgres) %_sysconfdir/%sname/*
%config(noreplace) %_sysconfdir/sysconfig/%sname
%_bindir/*
%_initdir/*
%_libdir/libpcp.so.*
%_libdir/pgsql/*
%_datadir/%sname
%_datadir/%prog_name
%_datadir/pgsql/extension/*
%_unitdir/*
%_tmpfilesdir/*
%_man1dir/*
%_man8dir/*
%attr(1775,root,postgres) %dir %_logdir/%sname

%changelog
