Name: portainer
Version: 2.33.2
Release: alt2

Summary: A lightweight docker management UI

License: Zlib
Group: System/Configuration/Other
Url: https://www.portainer.io
Vcs: https://github.com/portainer/portainer

# Source-url: %url/archive/%version/%name-%version.tar.gz
Source: %name-%version.tar
# go mod vendor
Source1: vendor.tar
#Source2-url: https://github.com/portainer/portainer/releases/download/%version/portainer-%{version}-linux-amd64.tar.gz
Source2: %name-amd64.tar
#Source3-url: https://github.com/portainer/portainer/releases/download/%version/portainer-%{version}-linux-arm64.tar.gz
Source3: %name-arm64.tar
Source4: portainer.desktop
Source5: portainer.png
Source6: portainer.service
Patch: %name-%version-%release.patch

ExclusiveArch: x86_64 aarch64 loongarch64 riscv64

BuildRequires(pre): golang
BuildRequires: rpm-build-golang /proc

Requires: docker-compose-v2

# The specified file is in docker-compose-v2 but it is not detected.
%filter_from_requires \/usr\/lib\/docker\/cli-plugins\/docker-compose/d

%if "%(rpmquery --qf '%%{VERSION}' golang)" >= "1.24.6"
%def_enable genbin
%else
%def_disable genbin
%endif

%define gover %(rpmquery --qf '%%{VERSION}' golang)

%description
%summary.

%prep
%setup -a1
# use portainer/public from x86_64 release on loongarch64 and riscv64
%ifarch x86_64 loongarch64 riscv64
    tar -xf %SOURCE2
%endif
%ifarch aarch64
    tar -xf %SOURCE3
%endif
%patch -p1

%build
%if_enabled genbin
go build -x \
   -mod=vendor \
   -buildmode=pie \
   -trimpath \
   --installsuffix cgo \
   --ldflags="-s -X 'github.com/portainer/liblicense.LicenseServerBaseURL=https://api.portainer.io' \
   -X 'github.com/portainer/portainer/pkg/build.BuildNumber=%release' \
   -X 'github.com/portainer/portainer/pkg/build.GitCommit=52ea23ef56cb25eede29c995f7d971d011eb24d0' \
   -X 'github.com/portainer/portainer/pkg/build.GoVersion=%gover'" \
   -o "bin/portainer" ./api/cmd/portainer
%else
%ifarch loongarch64 riscv64
echo >&2 "Using prebuild binearies is not supported on this architecture"
exit 1
%endif
%endif

%install
%if_enabled genbin
install -Dm755 bin/portainer %buildroot%_bindir/portainer
%else
install -Dm755 portainer/portainer %buildroot%_bindir/portainer
%endif

mkdir -p %buildroot%_datadir/portainer
cp -rip portainer/public %buildroot%_datadir/portainer/public

install -Dm644 %SOURCE5 %buildroot%_iconsdir/hicolor/scalable/apps/portainer.png
install -Dm644 %SOURCE4 %buildroot%_desktopdir/portainer.desktop
install -Dm644 %SOURCE6 %buildroot%_unitdir/portainer.service

ln -s %_libexecdir/docker/cli-plugins/docker-compose %buildroot%_datadir/portainer/docker-compose
ln -s %_bindir/docker %buildroot%_datadir/portainer/docker

mkdir -p %buildroot%_localstatedir/portainer/

%pre
getent group portainer >/dev/null || groupadd -r portainer
getent passwd portainer >/dev/null || \
    useradd -r -g portainer -d %_localstatedir/portainer -s /sbin/nologin \
    -c "portainer user" portainer
exit 0

%post
%post_service portainer.service

%preun
%preun_service portainer.service

%files
%doc LICENSE README.md
%_bindir/portainer
%_unitdir/portainer.service
%_desktopdir/portainer.desktop
%_datadir/portainer/
%_iconsdir/hicolor/scalable/apps/portainer.png
%attr(700,portainer,portainer) %dir %_localstatedir/portainer/

%changelog
