Name: popa3d
Version: 1.0.3
Release: alt2

Summary: Post Office Protocol (POP3) server
License: GPLv2+
Group: System/Servers
Url: http://www.openwall.com/popa3d/

# ftp://ftp.openwall.com/pub/projects/popa3d/popa3d-%version.tar.gz
Source: popa3d-%version.tar
Source1: popa3d-params.h
Source2: popa3d.pamd
Source3: popa3d.xinetd
# The dia source to popa3d.eps is available through the download link
# from http://www.openwall.com/presentations/Owl/
Source4: popa3d.eps

PreReq: shadow-utils, /var/empty

# Automatically added by buildreq on Fri May 31 2002
BuildRequires: libpam-devel pam_userpass-devel

%description
popa3d is a tiny Post Office Protocol version 3 (POP3) server with
security as its primary design goal.

%prep
%setup -q
install -pm644 %_sourcedir/popa3d-params.h params.h
install -pm644 %_sourcedir/popa3d.eps .
bzip2 -9 *.eps

%build
make clean
%make_build \
	CFLAGS="$RPM_OPT_FLAGS %optflags_notraceback $(getconf LFS_CFLAGS) -DHAVE_PROGNAME" \
	LIBS="-lpam -lpam_userpass" \
	LDFLAGS=

%install
%makeinstall_std SBINDIR=%_sbindir MANDIR=%_mandir
install -pD -m600 %_sourcedir/popa3d.pamd \
	%buildroot%_sysconfdir/pam.d/popa3d
install -pD -m640 %_sourcedir/popa3d.xinetd \
	%buildroot%_sysconfdir/xinetd.d/popa3d

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%post
/usr/sbin/groupadd -r -f popa3d
/usr/sbin/useradd -r -g popa3d -d /dev/null -s /dev/null -n popa3d >/dev/null 2>&1 ||:

%files
%_sbindir/popa3d
%_man8dir/popa3d.*
%config(noreplace) %_sysconfdir/pam.d/popa3d
%config(noreplace) %_sysconfdir/xinetd.d/*
%doc CHANGES CONTACT DESIGN LICENSE VIRTUAL
%doc popa3d.eps.bz2

%changelog
