Name:     pop-launcher
Version:  1.2.7
Release:  alt1

Summary:  Modular IPC-based desktop launcher service
License:  MPL-2.0
Group:    Graphical desktop/Other
Url:      https://github.com/pop-os/launcher

ExcludeArch: ppc64le

# Source-url: https://github.com/pop-os/launcher/archive/refs/tags/%version.tar.gz
Source: %name-%version.tar

# auto predownloaded cargo modules during update version with rpmgs from etersoft-build-utils
Source1: %name-development-%version.tar

%filter_from_requires /gnome-terminal/d
%filter_from_requires /gnome-session/d

# https://bugzilla.altlinux.org/40901
Requires: /proc

BuildRequires(pre): rpm-macros-rust
BuildRequires: rpm-build-rust
BuildRequires: /proc

BuildRequires: just
BuildRequires: pkgconfig(xkbcommon)

%description
%summary.

%prep
%setup -a1

mkdir -p .cargo
cat <<EOF >> .cargo/config.toml
[source.crates-io]
replace-with = "vendored-sources"

[source."git+https://github.com/pop-os//cosmic-protocols"]
git = "https://github.com/pop-os//cosmic-protocols"
replace-with = "vendored-sources"

[source."git+https://github.com/pop-os/dbus-settings-bindings"]
git = "https://github.com/pop-os/dbus-settings-bindings"
replace-with = "vendored-sources"

[source.vendored-sources]
directory = "vendor"
EOF

%build
%rust_build -p pop-launcher-bin \
%ifarch %ix86
    --config 'profile.release.lto=false'
%endif

%install
just rootdir=%buildroot install-bin
just rootdir=%buildroot bin-path=%_bindir/%name install-scripts
just rootdir=%buildroot bin-path=%_bindir/%name install-plugins

%files
%doc README.md
%_bindir/%name
%_libexecdir/%name/

%changelog
