Name: polkit
Version: 126
Release: alt2

Summary: PolicyKit Authorization Framework
License: LGPLv2+
Group: System/Libraries

URL: http://www.freedesktop.org/wiki/Software/PolicyKit
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Requires: lib%name = %version-%release
Requires(pre): dbus

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++ gobject-introspection-devel gtk-doc libexpat-devel libpam-devel
BuildRequires: pkgconfig(duktape) pkgconfig(systemd)

%description
PolicyKit is a toolkit for defining and handling authorizations.
It is used for allowing unprivileged processes to speak to privileged
processes.

%package -n lib%name
Summary: PolicyKit libraries
Group: System/Libraries
Provides: lib%{name}1 = %version-%release
Obsoletes: lib%{name}1 < %version

%description -n lib%name
Libraries for interacting with PolicyKit

%package -n lib%name-devel
Summary: Development libraries and headers for PolicyKit
Group: Development/C
Requires: lib%name = %version-%release
Requires: lib%name-gir = %version-%release
Provides: lib%{name}1-devel = %version-%release
Obsoletes: lib%{name}1-devel < %version
Provides: lib%{name}1-gir-devel = %version-%release
Obsoletes: lib%{name}1-gir-devel < %version
Provides: lib%{name}-gir-devel = %version-%release
Obsoletes: lib%{name}-gir-devel < %version

%description -n lib%name-devel
Headers, libraries and API docs for PolicyKit

%package -n lib%name-gir
Summary: GObject introspection data for the Polkit-1.0 library
Group: System/Libraries
Requires: lib%name = %version-%release
Provides: lib%{name}1-gir = %version-%release
Obsoletes: lib%{name}1-gir < %version

%description -n lib%name-gir
GObject introspection data for the Polkit-1.0 library

%package default-rules
Summary: Default rules for polkit
Group: System/Libraries
BuildArch: noarch

%description default-rules
Contains a configuration file that describes that a user in the wheel group
is an administrator.

%prep
%setup
%patch -p1

touch ChangeLog

%build
%meson \
	-D authfw=pam \
	-D os_type=redhat \
	-D examples=false \
	-D gtk_doc=true \
	-D introspection=true \
	-D man=true \
	-D session_tracking=logind \
	-D pam_prefix=%_sysconfdir/pam.d
%meson_build

%install
%meson_install
%find_lang %name-1

%pre
groupadd -r -f polkitd 2>/dev/null ||:
useradd -r -n -g polkitd -d / \
	-s /dev/null -c "User for polkitd" polkitd 2>/dev/null ||:

%files -f %name-1.lang
%dir %_sysconfdir/%name-1
%attr(0700,polkitd,root) %dir %_sysconfdir/%name-1/rules.d
%_datadir/dbus-1/system.d/org.freedesktop.PolicyKit1.conf
%_sysconfdir/pam.d/polkit-1
%_bindir/pk[act]*
%attr(4511,root,root) %_bindir/pkexec
%dir %_prefix/lib/%name-1
%_prefix/lib/%name-1/polkitd
%attr(4511,root,root) %_prefix/lib/polkit-1/polkit-agent-helper-1
%dir %_datadir/%name-1
%dir %_datadir/%name-1/actions
%attr(0700,polkitd,root) %dir %_datadir/%name-1/rules.d
%_datadir/%name-1/policyconfig-1.dtd
%_datadir/%name-1/actions/org.freedesktop.policykit.policy
%_datadir/dbus-1/system-services/org.freedesktop.PolicyKit1.service
%_unitdir/polkit.service
%_tmpfilesdir/polkit-tmpfiles.conf
%_sysusersdir/polkit.conf
%_man1dir/*.1*
%_man8dir/*.8*

%files default-rules
%_datadir/%name-1/rules.d/50-default.rules

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-gir
%_typelibdir/*.typelib

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/gettext/its/%name.its
%_datadir/gettext/its/%name.loc
%_datadir/gtk-doc/html/%name-1/
%_girdir/*.gir

%changelog
