Group: Development/Java
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-default
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           plexus-interactivity
Summary:        Plexus Interactivity Handler Component
Epoch:          0
Version:        1.0
Release:        alt6_2jpp11
License:        MIT

URL:            https://github.com/codehaus-plexus/plexus-interactivity
Source0:        %{url}/archive/%{name}-%{version}.tar.gz
Source1:        LICENSE.MIT

BuildArch:      noarch

BuildRequires:  maven-local
BuildRequires:  mvn(jline:jline) >= 2
BuildRequires:  mvn(org.codehaus.plexus:plexus-components:pom:)
BuildRequires:  mvn(org.codehaus.plexus:plexus-container-default)
BuildRequires:  mvn(org.codehaus.plexus:plexus-utils)
Source44: import.info

%description
The Plexus project seeks to create end-to-end developer tools for
writing applications. At the core is the container, which can be
embedded or for a full scale application server. There are many
reusable components for hibernate, form processing, jndi, i18n,
velocity, etc. Plexus also includes an application server which
is like a J2EE application server, without all the baggage.


%package javadoc
Group: Development/Java
Summary:        API documentation for %{name}
BuildArch: noarch

%description javadoc
This package provides %{summary}.


%package api
Group: Development/Java
Summary:        API for %{name}

%description api
API module for %{name}.


%package jline
Group: Development/Java
Summary:        jline module for %{name}

%description jline
jline module for %{name}.


%prep
%setup -q -n %{name}-%{name}-%{version}


cp %{SOURCE1} .

# use jline2, not jline1
%pom_change_dep jline:jline jline:jline:2.10 plexus-interactivity-jline
sed -i "s!jline.ConsoleReader!jline.console.ConsoleReader!" \
    plexus-interactivity-jline/src/main/java/org/codehaus/plexus/components/interactivity/jline/JLineInputHandler.java

%pom_remove_plugin :maven-site-plugin

%mvn_file ":{plexus}-{*}" @1/@2

%mvn_package ":plexus-interactivity"


%build
%mvn_build -s -- -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8 -Dmaven.javadoc.source=1.8 -Dmaven.compiler.release=8


%install
%mvn_install


%files -f .mfiles
%doc --no-dereference LICENSE.MIT

%files api -f .mfiles-plexus-interactivity-api
%doc --no-dereference LICENSE.MIT

%files jline -f .mfiles-plexus-interactivity-jline
%doc --no-dereference LICENSE.MIT

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE.MIT


%changelog
