%def_enable snapshot

%define ver_major 2023
%define api_ver 1.0
%define gst_api_ver 1.0
%define gst_ver 1.18.0
%define gtk_api_ver 3.0
%define gtk_ver 3.24
%define gi_ver 1.32
%define peas_api_ver 1.0

%define xdg_name org.pitivi.Pitivi

%def_disable check

Name: pitivi
Version: %ver_major.03.0
Release: alt2.1

Summary: PiTiVi allows users to easily edit audio/video projects
License: LGPL-2.1-or-later
Group: Video
Url: http://www.pitivi.org/

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%add_python3_path %_libdir/%name/python

# should be provided by python3-module-gst1.0
%add_python3_req_skip gi.repository.GstPbutils

Requires: typelib(Gtk) = %gtk_api_ver
Requires: typelib(Peas) = %peas_api_ver
Requires: libpeas-python3-loader
Requires: python3-module-gst%gst_api_ver >= %gst_ver
Requires: gstreamer-editing-services
Requires: gst-devtools
Requires: gst-libav >= %gst_ver
Requires: gst-plugins-base%gst_api_ver >= %gst_ver
Requires: gst-plugins-good%gst_api_ver >= %gst_ver
Requires: gst-plugins-bad%gst_api_ver >= %gst_ver
Requires: gst-plugins-ugly%gst_api_ver >= %gst_ver
Requires: python3-module-canberra
Requires: python3(matplotlib)
# optional
#Requires: python3(librosa)

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-gir
BuildRequires: meson desktop-file-utils gtk-doc python3-module-nose2
BuildRequires: yelp-tools libappstream-glib-devel libcairo-devel
BuildRequires: python3-devel python3-module-pygobject3-devel
BuildRequires: python3-module-pycairo-devel
BuildRequires: gst-plugins%gst_api_ver-devel gst-plugins-bad%gst_api_ver-devel >= %gst_ver
BuildRequires: libgtk+3-devel >= %gtk_ver gobject-introspection-devel >= %gi_ver
BuildRequires: libgstreamer%gst_api_ver-gir-devel gst-plugins%gst_api_ver-gir-devel
BuildRequires: gst-devtools libgtk+3-gir-devel
%{?_enable_check:BuildRequires: xvfb-run desktop-file-utils /usr/bin/appstreamcli
BuildRequires: typelib(Peas) = %peas_api_ver gst-devtools typelib(GES)}


%description
Pitivi is a video editor built upon the GStreamer Editing Services.
It aims to be an intuitive and flexible application that can appeal to
newbies and professionals alike.

%prep
%setup

%build
%meson
%meson_build %name-pot %name-update-po
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%check
xvfb-run %__meson_test -t 4

%files -f %name.lang
%_bindir/%name
%_libdir/%name/
%_datadir/%name/
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/*/*
%_datadir/metainfo/%xdg_name.appdata.xml
%_datadir/mime/packages/%xdg_name-mime.xml

%changelog
