%def_disable snapshot
%define _unpackaged_files_terminate_build 1

%ifarch armh
%define optflags_lto %nil
%endif

%define _libexecdir %prefix/libexec
%define ver_major 1.4
%define ms_ver 0.4.2
%define api_ver 0.3
%define spa_api_ver 0.2
%define gst_api_ver 1.0
%define libcamera_ver 0.2.0

%def_enable gstreamer
%def_enable systemd
%def_enable jack_devel
%define jackit_ver 1:1.9.22-alt1
%define jack_ver 1.9.17
%def_disable media_session
%def_enable libusb
%def_enable libffado
%def_enable libcamera
%def_enable avahi
%def_enable webrtc
%def_enable sdl
%def_enable lv2
%def_enable libcanberra
%def_enable lc3
# bluez5-backend-native-mm
# https://gitlab.freedesktop.org/pipewire/pipewire/-/merge_requests/1379
%def_enable mm
#system service: not recommended and disabled by default
%def_disable systemd_system_service
%def_enable selinux
# disabled by default
%def_disable vulkan
%def_enable xfixes
# libapparmor required
%def_disable snap
%ifarch %e2k
%def_disable examples
%else
%def_enable examples
%endif
%def_disable docs
%def_enable man
%def_enable check

Name: pipewire
Version: %ver_major.9
Release: alt1

Summary: Media Sharing Server
Group: System/Servers
License: MIT
Url: https://pipewire.org/

Vcs: https://github.com/PipeWire/pipewire.git

%if_disabled snapshot
Source: https://github.com/PipeWire/pipewire/archive/%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif
#https://gitlab.freedesktop.org/pipewire/media-session.git
# 0.4.1-15
Source1: media-session-%ms_ver.tar
Patch: %name-0.3.19-alt-rpath.patch

Requires: %name-libs = %EVR
#Requires: wireplumber
Requires: rtkit
%{?_enable_gstreamer:%{?_enable_libcamera:Requires: gst-plugins-libcamera1.0}}

%define meson_ver 0.59
%define gst_ver 1.10
%define mm_ver 1.10.0

BuildRequires(pre): rpm-macros-meson rpm-build-systemd
BuildRequires: meson >= %meson_ver libgio-devel libudev-devel libdbus-devel
BuildRequires: libalsa-devel libpulseaudio-devel
BuildRequires: libv4l-devel libsamplerate-devel libsndfile-devel
BuildRequires: libavformat-devel libavcodec-devel libavfilter-devel
BuildRequires: libbluez-devel
# BT codecs
BuildRequires: libsbc-devel libfdk-aac-devel libldac-devel
BuildRequires: libfreeaptx-devel libopus-devel
%{?_enable_lc3:BuildRequires: liblc3-devel}
%{?_enable_mm:BuildRequires: pkgconfig(ModemManager) >= %mm_ver}
# LC3plus BT codec
# BuildRequires: lc3plus-devel
# for pw-top
BuildRequires: libncursesw-devel libncurses-devel
# for pw-cli
BuildRequires: libreadline-devel
%if_enabled gstreamer
BuildRequires: pkgconfig(gstreamer-%gst_api_ver) >= %gst_ver
BuildRequires: pkgconfig(gstreamer-base-%gst_api_ver)
BuildRequires: pkgconfig(gstreamer-plugins-base-%gst_api_ver)
BuildRequires: pkgconfig(gstreamer-net-%gst_api_ver)
BuildRequires: pkgconfig(gstreamer-allocators-%gst_api_ver)
%endif
# filter-graphs
BuildRequires: libmysofa-devel
BuildRequires: libebur128-devel
%{?_enable_lv2:BuildRequires: liblilv-devel}
# fftw3f (filter-chain convolver)
BuildRequires: pkgconfig(fftw3f)
%{?_enable_systemd:BuildRequires: pkgconfig(systemd)}
%{?_enable_wireplumber:BuildRequires: libwireplumber-devel}
%{?_enable_vulkan:BuildRequires: libvulkan-devel}
%{?_enable_xfixes:BuildRequires: pkgconfig(xfixes)}
%{?_enable_libusb:BuildRequires: pkgconfig(libusb-1.0)}
%{?_enable_libffado:BuildRequires: pkgconfig(libffado)}
%{?_enable_libcamera:BuildRequires: libcamera-devel >= %libcamera_ver libdrm-devel}
%{?_enable_avahi:BuildRequires: pkgconfig(avahi-client)}
%{?_enable_webrtc:BuildRequires: pkgconfig(webrtc-audio-processing-2)}
%{?_enable_sdl:BuildRequires: libSDL2-devel}

%{?_enable_libcanberra:BuildRequires: libcanberra-devel}
%{?_enable_selinux:BuildRequires: libselinux-devel}
%{?_enable_snap:BuildRequires: pkgconfig(snapd-glib-2) pkgconfig(libapparmor)}
%{?_enable_docs:BuildRequires: doxygen graphviz /usr/bin/dot fonts-otf-adobe-source-sans-pro fonts-ttf-google-droid-sans}
%{?_enable_man:BuildRequires: doxygen}
%{?_enable_check:BuildRequires: /proc gcc-c++ libcap-devel}

%description
PipeWire is a multimedia server for Linux and other Unix like operating
systems.

%package libs
Summary: Libraries for PipeWire clients
Group: System/Libraries

%description libs
This package contains the runtime libraries for any application that wishes
to interface with a PipeWire media server.

%package libs-devel
Summary: Headers and libraries for PipeWire client development
Group: Development/C
Requires: %name-libs = %EVR

%description libs-devel
Headers and libraries for developing applications that can communicate with
a PipeWire media server.

%package libs-devel-doc
Summary: PipeWire media server documentation
Group: Documentation
# https://bugzilla.altlinux.org/34101
# "dot output is inconsistent across architectures"
BuildArch: noarch
Conflicts: %name-libs-devel < %version

%description libs-devel-doc
This package contains documentation for the PipeWire media server.

%package utils
Summary: PipeWire media server utilities
Group: System/Servers
Requires: %name-libs = %EVR

%description utils
This package contains command line utilities for the PipeWire media server.

%package jack
Summary: PipeWire JACK
Group: System/Servers
Requires: %name-jack-libs = %EVR
Conflicts: jack-audio-connection-kit
Obsoletes: jack-audio-connection-kit < %jackit_ver
Obsoletes: jackd < %jackit_ver
Provides: jackd = %EVR

%description jack
This package provides a JACK implementation based on PipeWire.

%package jack-libs
Summary: PipeWire JACK libraries
Group: System/Libraries
Requires: %name-libs = %EVR
Conflicts: libjack
Obsoletes: libjack < %jackit_ver

%description jack-libs
This package provides PipeWire JACK libraries

%package jack-libs-devel
Summary: development files for PipeWire JACK
Group: Development/C
Requires: %name-libs-devel = %EVR
Requires: %name-jack-libs = %EVR
Conflicts: libjack-devel
Obsoletes: libjack-devel < %jackit_ver
Provides: jackit-devel = %jack_ver
Provides: libjack-devel = %jack_ver

%description jack-libs-devel
This package provides development files for PipeWire JACK.

%prep
%setup %{?_enable_media_session:-a1}

%ifarch %e2k
# no attribute cleanup in C++ mode, but it's only used in C sources
sed -i 's/__has_attribute(__cleanup__)/!defined(__cplusplus)/' spa/include/spa/utils/cleanup.h
sed -i -E 's/static const char \*const (.*) =/#define \1 /;T;:a;s/;$//;t;s/$/\\/;n;ba' \
    src/modules/module-protocol-pulse/modules/module-*.c
%endif

%{?_enable_media_session:mv media-session-%ms_ver subprojects/media-session}

%build
export LIB=%_lib
%meson \
	%{subst_enable_meson_feature docs docs} \
	%{subst_enable_meson_feature man man} \
	%{subst_enable_meson_bool jack_devel jack-devel} \
	%{subst_enable_meson_feature gstreamer gstreamer} \
	%{subst_enable_meson_feature vulkan vulkan} \
	%{subst_enable_meson_feature libusb libusb} \
	%{subst_enable_meson_feature libffado libffado} \
	%{subst_enable_meson_feature libcamera libcamera} \
	%{subst_enable_meson_feature avahi avahi} \
	%{subst_enable_meson_feature webrtc echo-cancel-webrtc} \
	%{subst_enable_meson_feature sdl sdl2} \
	%{subst_enable_meson_feature lv2 lv2} \
	%{subst_enable_meson_feature libcanberra libcanberra} \
	%{subst_enable_meson_feature lc3 bluez5-codec-lc3} \
	%{subst_enable_meson_feature mm bluez5-backend-native-mm} \
	%{subst_enable_meson_feature systemd systemd} \
	%{subst_enable_meson_feature selinux selinux} \
	%{subst_enable_meson_feature snap snap} \
	%{subst_enable_meson_feature systemd_system_service systemd-system-service} \
	%{subst_enable_meson_feature examples examples} \
	%{?_enable_media_session:-Dsession-managers='media-session'} \
	%{?_disable_media_session:-Dsession-managers='[]'} \
	-Dudevrulesdir='%_udevrulesdir' \
	-Dsystemd-system-unit-dir='%_unitdir' \
	-Dsystemd-user-unit-dir='%_userunitdir'
%nil
%meson_build

%install
%meson_install
mkdir -p %buildroot%_sysconfdir/%name/{media-session.d,filter-chain}
%find_lang %name media-session --output=%name.lang

# https://bugzilla.altlinux.org/47286
mkdir -p %buildroot%_sysconfdir/ld.so.conf.d/
echo %_libdir/pipewire-%api_ver/jack/ > %buildroot%_sysconfdir/ld.so.conf.d/pipewire-jack-%_arch.conf

%check
%__meson_test

%pre
%_sbindir/groupadd -r -f %name 2>/dev/null ||:
%_sbindir/useradd -r -N -g %name -d / \
	-s /dev/null -c "PipeWire System Daemon" %name 2>/dev/null ||:

%files -f %name.lang
%_bindir/%name
%_bindir/%name-aes67
%_bindir/%name-avb
%_bindir/%name-pulse
%{?_enable_vulkan:%_bindir/%name-vulkan}
%{?_enable_media_session:%_bindir/%name-media-session}
%{?_enable_gstreamer:%_libdir/gstreamer-%gst_api_ver/libgst%name.so}
%_sysconfdir/security/limits.d/25-pw-rlimits.conf
%dir %_sysconfdir/%name/
%dir %_sysconfdir/%name/media-session.d
%dir %_sysconfdir/%name/filter-chain
%dir %_datadir/%name
%_datadir/%name/%name.conf
%_datadir/%name/%name-aes67.conf
%_datadir/%name/client.conf

%_datadir/%name/minimal.conf
%_datadir/%name/%name-avb.conf
%_datadir/%name/%name-pulse.conf
%{?_enable_vulkan:%_datadir/%name/%name-vulkan.conf}
%_datadir/%name/filter-chain.conf

%dir %_datadir/%name/client.conf.avail
%_datadir/%name/client.conf.avail/20-upmix.conf

%dir %_datadir/%name/%name-pulse.conf.avail
%_datadir/%name/%name-pulse.conf.avail/20-upmix.conf

%dir %_datadir/%name/%name.conf.avail
%_datadir/%name/%name.conf.avail/10-rates.conf
%_datadir/%name/%name.conf.avail/20-upmix.conf
%_datadir/%name/%name.conf.avail/50-raop.conf

%{?_enable_media_session:
%dir %_datadir/%name/media-session.d
%_datadir/%name/media-session.d/alsa-monitor.conf
%_datadir/%name/media-session.d/bluez-monitor.conf
%_datadir/%name/media-session.d/media-session.conf
%_datadir/%name/media-session.d/v4l2-monitor.conf
%_datadir/%name/media-session.d/with-pulseaudio
}
%dir %_datadir/%name/filter-chain
%_datadir/%name/filter-chain/demonic.conf
%_datadir/%name/filter-chain/sink-dolby-surround.conf
%_datadir/%name/filter-chain/sink-eq6.conf
%_datadir/%name/filter-chain/sink-make-LFE.conf
%_datadir/%name/filter-chain/sink-matrix-spatialiser.conf
%_datadir/%name/filter-chain/sink-mix-FL-FR.conf
%_datadir/%name/filter-chain/sink-upmix-5.1-filter.conf
%_datadir/%name/filter-chain/sink-virtual-surround-5.1-kemar.conf
%_datadir/%name/filter-chain/sink-virtual-surround-7.1-hesuvi.conf
%_datadir/%name/filter-chain/source-rnnoise.conf
%_datadir/%name/filter-chain/source-duplicate-FL.conf

%dir %_datadir/spa-%spa_api_ver
%dir %_datadir/spa-%spa_api_ver/bluez5
%_datadir/spa-%spa_api_ver/bluez5/bluez-hardware.conf

%_udevrulesdir/90-%name-alsa.rules
%_datadir/alsa-card-profile/

%if_enabled systemd
%_userunitdir/%name.service
%_userunitdir/%name.socket
%_userunitdir/%name-pulse.service
%_userunitdir/%name-pulse.socket
%{?_enable_media_session:%_userunitdir/%name-media-session.service}
%_userunitdir/filter-chain.service
%{?_enable_systemd_system_service:
%_unitdir/%name.service
%_unitdir/%name.socket
%_unitdir/%name-pulse.service
%_unitdir/%name-pulse.socket
%_unitdir/%name-manager.socket
}
%endif

%_datadir/alsa/alsa.conf.d/50-pipewire.conf
%_datadir/alsa/alsa.conf.d/99-pipewire-default.conf

%if_enabled man
%_man1dir/%name.1*
%_man1dir/%name-pulse.1*
%_man5dir/%name.conf.5*
%_man5dir/%name-pulse.conf.5*
%_man5dir/%name-client.conf.5.xz
%_man5dir/%name-filter-chain.conf.5.xz
%_man5dir/%name-jack.conf.5.xz
%endif
%doc README* NEWS

%files libs
%_libdir/lib%name-%api_ver.so.*
%_libdir/%name-%api_ver/
%exclude %_libdir/%name-%api_ver/jack
%_libdir/spa-%spa_api_ver/
%_libdir/alsa-lib/

%files libs-devel
%_libdir/lib%name-%api_ver.so
%_includedir/%name-%api_ver/
%_includedir/spa-%spa_api_ver/
%_pkgconfigdir/lib%name-%api_ver.pc
%_pkgconfigdir/libspa-%spa_api_ver.pc
%_man7dir/*

%if_enabled docs
%files libs-devel-doc
%dir %_datadir/doc/%name
%_datadir/doc/%name/html/
%endif

%files utils
%_bindir/pw-cat
%_bindir/pw-cli
%_bindir/pw-config
%_bindir/pw-container
%_bindir/pw-dot
%_bindir/pw-dsdplay
%_bindir/pw-dump
%_bindir/pw-encplay
%_bindir/pw-link
%_bindir/pw-loopback
%_bindir/pw-metadata
%_bindir/pw-mididump
%_bindir/pw-midiplay
%_bindir/pw-midirecord
%_bindir/pw-mon
%_bindir/pw-play
%_bindir/pw-profiler
%_bindir/pw-record
%_bindir/pw-reserve
%_bindir/pw-top
%_bindir/pw-v4l2
%_bindir/spa-acp-tool
%_bindir/spa-inspect
%_bindir/spa-json-dump
%_bindir/spa-monitor
%_bindir/spa-resample
%if_enabled man
%_man1dir/pw-cat.1.*
%_man1dir/pw-cli.1*
%_man1dir/pw-config.1*
%_man1dir/pw-container.1*
%_man1dir/pw-dot.1.*
%_man1dir/pw-dump.1.*
%_man1dir/pw-link.1.*
%_man1dir/pw-loopback.1.*
%_man1dir/pw-metadata.1.*
%_man1dir/pw-mididump.1.*
%_man1dir/pw-mon.1*
%_man1dir/pw-profiler.1.*
%_man1dir/pw-reserve.1*
%_man1dir/pw-top.1.*
%_man1dir/pw-v4l2.1*
%_man1dir/spa-acp-tool.1*
%_man1dir/spa-inspect.1*
%_man1dir/spa-json-dump.1*
%_man1dir/spa-monitor.1*
%_man1dir/spa-resample.1*
%endif

%files jack
%_bindir/pw-jack
%_datadir/%name/jack.conf
%{?_enable_media_session:%_datadir/%name/media-session.d/with-jack}
%{?_enable_man:%_man1dir/pw-jack.1*}

%files jack-libs
%_sysconfdir/ld.so.conf.d/%name-jack-%_arch.conf
%_libdir/%name-%api_ver/jack/*.so.*

%files jack-libs-devel
%_includedir/jack/
%_libdir/%name-%api_ver/jack/*.so
%_pkgconfigdir/jack.pc
%_pkgconfigdir/jackserver.pc

%changelog
