%define dotnet_version 9.0

%def_with prebuild

Name: pinta
Version: 3.0.4
Release: alt1

Summary: An easy to use drawing and image editing program

Group: Graphics

# the code is licensed under the MIT license while the icons are licensed as CC-BY
License: MIT and CC-BY-3.0
Url: http://pinta-project.com/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/PintaProject/Pinta/releases/download/%version/%name-%version.tar.gz
Source: %name-%version.tar
%if_with prebuild
Source1: packages.tar
%endif

ExclusiveArch: %dotnet_arches

BuildRequires(pre): rpm-macros-dotnet
BuildRequires: /proc
BuildRequires: autoconf-archive
BuildRequires: dotnet-sdk-%dotnet_version
BuildRequires: intltool
BuildRequires: libadwaita-devel

Requires: dotnet-%dotnet_version

%description
Pinta is a free, open-source program for drawing and image editing.
It combines intuitive tools with powerful features, making it easy to create,
enhance, and manipulate images. Whether you're sketching or retouching photos,
Pinta keeps things simple without sacrificing functionality.

%prep
%setup %{?_with_prebuild:-a1}
%__subst 's!PINTA_BUILD_OPTS =!PINTA_BUILD_OPTS = --source ./packages!' Makefile.am
%__subst 's!lib_dir?.Name == "lib"!lib_dir?.Name == "%_lib"!' Pinta.Core/Managers/SystemManager.cs

%build
%if_without prebuild
# no certificates: https://bugzilla.altlinux.org/53633
export DOTNET_NUGET_SIGNATURE_VERIFICATION=false
dotnet restore Pinta/Pinta.csproj \
	-p:TargetFramework=net%dotnet_version \
	--packages ./packages
%endif

export DOTNET_CLI_TELEMETRY_OPTOUT=true
%autoreconf
%configure
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%doc readme.md license-mit.txt license-pdn.txt
%_bindir/%name
%_libdir/%name/
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/*/*
%_man1dir/%{name}*
%_pixmapsdir/%{name}*
%_datadir/metainfo/%name.appdata.xml

%changelog
