%set_verify_elf_method unresolved=relaxed

Name: phosphor-pid-control
Version: 1.0.0
Release: alt1.git951aff4

Summary: OpenBMC PID-based Thermal Control Daemon
License: Apache-2.0
Group: Other
Url: https://github.com/openbmc/phosphor-pid-control
Vcs: https://github.com/openbmc/phosphor-pid-control.git

Source: %name-%version.tar

BuildRequires(pre): rpm-macros-meson

BuildRequires: cli11-devel
BuildRequires: cmake
BuildRequires: meson
BuildRequires: gcc-c++
BuildRequires: libphosphor-dbus-interfaces-devel
BuildRequires: phosphor-host-ipmid-devel
BuildRequires: libphosphor-logging-devel
BuildRequires: libsystemd-devel
BuildRequires: nlohmann-json-devel
BuildRequires: pkg-config

%description
This is a daemon running within the OpenBMC environment. It uses a
well-defined configuration file to control the temperature of the tray
components to keep them within operating conditions. It may require
coordination with host-side tooling and OpenBMC.

%package tools
Summary: Tools for %name
Group: Other
Requires: libmanualcmds = %EVR

%description tools
%summary.

%package -n libmanualcmds
Summary: Library from %name
Group: System/Libraries

%description -n libmanualcmds
%summary.

%package -n libmanualcmds-devel
Summary: Development files for library from %name
Group: Development/C++
Requires: libmanualcmds = %EVR

%description -n libmanualcmds-devel
%summary.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install

%files tools
%_bindir/setsensor
%_bindir/swampd
%_unitdir/%name.service

%files -n libmanualcmds
%_libdir/ipmid-providers/libmanualcmds.so.*

%files -n libmanualcmds-devel
%_libdir/ipmid-providers/libmanualcmds.so

%changelog
