%def_enable snapshot
%define _libexecsir %_prefix/libexec
%define ver_major 0.50
%define api_ver 0
%define beta %nil
%define rdn_name sm.puri.Phoc
%define xdg_name mobi.phosh.Phoc

%define dev_uid 500
%define wlroots_ver_major 0.19
%define wlroots_ver %wlroots_ver_major.1
# since 0.48 system 0.19.1 may be used but patched version required
%def_enable embed_wlroots
%{?_enable_embed_wlroots:%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}}
%define gmobile_ver 0.1.0
%def_disable embed_gmobile
# since 0.48
%define gvdb_ver 4758f6f

%def_enable gtk_doc
%def_enable man
# disabled by default
%def_disable sysprof
%def_disable check

Name: phoc
Version: %ver_major.0
Release: alt1%beta

Summary: Display compositor designed for mobile devices
License: GPL-3.0-or-later
Group: Graphical desktop/GNOME
Url: https://gitlab.gnome.org/World/Phosh/phoc

Vcs: https://gitlab.gnome.org/World/Phosh/phoc.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif
%{?_enable_embed_gmobile:Source1: gmobile-%gmobile_ver.tar}
%{?_enable_embed_wlroots:Source2: wlroots-%wlroots_ver.tar}
Source3: gvdb-%gvdb_ver.tar

%define glib_ver 2.74
%define gmobile_ver 0.1.0
%define wayland_proto_ver 1.15
%define gnome_desktop_ver 43
%define libinput_ver 1.27

Provides: greetd-greeter

BuildRequires(pre): rpm-macros-meson rpm-build-systemd
BuildRequires: meson
BuildRequires: pkgconfig(gio-2.0) >= %glib_ver
BuildRequires: pkgconfig(gnome-desktop-3.0) >= %gnome_desktop_ver
BuildRequires: pkgconfig(gsettings-desktop-schemas)
BuildRequires: pkgconfig(libinput) >= %libinput_ver
BuildRequires: pkgconfig(pixman-1)
BuildRequires: pkgconfig(wayland-server)
BuildRequires: pkgconfig(xkbcommon)
BuildRequires: pkgconfig(libdrm)
BuildRequires: pkgconfig(libdisplay-info)
BuildRequires: pkgconfig(glesv2)
BuildRequires: pkgconfig(wayland-client)
BuildRequires: pkgconfig(wayland-cursor)
BuildRequires: pkgconfig(wayland-egl)
BuildRequires: pkgconfig(wayland-protocols) >= %wayland_proto_ver
BuildRequires: pkgconfig(json-glib-1.0)
BuildRequires: pkgconfig(xcb-icccm)
%{?_disable_embed_gmobile:BuildRequires: pkgconfig(gmobile) >= %gmobile_ver}
%{?_disable_embed_wlroots:BuildRequires: pkgconfig(wlroots) >= %wlroots_ver}
%{?_enable_embed_wlroots:BuildRequires: libgbm-devel libseat1-devel
BuildRequires: pkgconfig(xcb-renderutil)
BuildRequires: pkgconfig(xcb-errors)
BuildRequires: pkgconfig(hwdata)
BuildRequires: xorg-xwayland-devel libglvnd-devel libvulkan-devel glslang
BuildRequires: pkgconfig(libliftoff)
# since 0.19 for 'color-management'
BuildRequires: pkgconfig(lcms2)}
%{?_enable_gtk_doc:BuildRequires: gi-docgen pkgconfig(gobject-introspection-1.0) /usr/bin/g-ir-scanner}
%{?_enable_man:BuildRequires: /usr/bin/rst2man}
%{?_enable_sysprof:BuildRequires: pkgconfig(sysprof-capture-4)}
%{?_enable_check:BuildRequires: libgtest-devel xvfb-run mutter-gnome /usr/bin/Xwayland}

%description
Phoc is a wlroots based mobile devices compositor. Phoc is pronounced
like the English word fog.

%package devel-doc
Summary: Development documentation for Phoc
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
This package provides development documentation for Phoc wayland
compositor.

%prep
%setup -n %name-%version%beta %{?_enable_embed_gmobile:-a1} %{?_enable_embed_wlroots:-a2} -a3
%{?_enable_embed_gmobile:mv gmobile-%gmobile_ver subprojects/gmobile}
%{?_enable_embed_wlroots:mv wlroots-%wlroots_ver subprojects/wlroots-%wlroots_ver_major.x
pushd subprojects/wlroots-%wlroots_ver_major.x
for p in ../packagefiles/wlroots/*.patch; do
    patch -p1 -i $p
done
popd}

mv gvdb-%gvdb_ver subprojects/gvdb

%build
%meson \
    %{subst_enable_meson_feature embed_wlroots embed-wlroots} \
    %{?_enable_embed_wlroots:--default-library=static} \
    -Ddev-uid=%dev_uid \
    %{subst_enable_meson_bool gtk_doc gtk_doc} \
    %{subst_enable_meson_bool man man} \
    %{subst_enable_meson_feature sysprof sysprof}
%nil
%meson_build

%install
%meson_install

%{?_enable_embed_wlroots:
rm -r %buildroot%_includedir/wlroots*
rm %buildroot%_libdir/libwlroots*.a
rm %buildroot%_pkgconfigdir/wlroots*.pc}

%{?_enable_embed_gmobile:
rm %buildroot%_libdir/libgmobile.*
rm %buildroot%_pkgconfigdir/gmobile.pc}

%check
WLR_RENDERER=pixman xvfb-run %__meson_test

%files
%_bindir/%name
%_bindir/%name-outputs-states
%_desktopdir/%xdg_name.desktop
%_datadir/glib-2.0/schemas/sm.puri.phoc.gschema.xml
%_iconsdir/hicolor/symbolic/apps/%xdg_name.svg
%{?_enable_man:%_man1dir/%name.1*
%_man1dir/%name-outputs-states.1*
%_man5dir/%name.ini.5*
%_man5dir/%name.gsettings.5*}
%doc README.md NEWS

%files devel-doc
%_datadir/doc/%name-%api_ver/

%changelog
