%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: pgpdump
Version: 0.36
Release: alt1

Summary: A PGP packet visualizer
License: BSD-3-Clause
Group: File tools
Url: https://www.mew.org/~kazu/proj/pgpdump/
Vcs: https://github.com/kazu-yamamoto/pgpdump

Source: %name-%version.tar

BuildRequires: bzlib-devel
BuildRequires: zlib-devel

%description
pgpdump is a PGP packet visualizer which displays the packet format of
OpenPGP (RFC 4880) and PGP version 2 (RFC 1991).

The output of this command is similar to the one of GnuPG's `list
packets' command, however, pgpdump produces a more detailed and easier
to understand.

%prep
%setup

%build
%ifarch x86_64
%add_optflags -fanalyzer -Werror
%endif
%autoreconf
%configure
%make

%install
install -D pgpdump %buildroot%_bindir/pgpdump
install -D pgpdump.1 %buildroot%_man1dir/pgpdump.1

%check
./pgpdump -v |& grep -P '^pgpdump version \Q%version,'
data/test.sh -v

%files
%doc CHANGES COPYRIGHT README.md
%_bindir/pgpdump
%_man1dir/pgpdump.*

%changelog
