%define        _unpackaged_files_terminate_build 1
%define        dist tk
%def_with      xft

Name:          perl-%dist
Version:       804.036.28
Release:       alt0.2
Summary:       Perl modules providing the Tk graphics library
License:       Artistic-1.0 or GPL-2.0-or-later
Group:         Development/Perl
Url:           %CPAN %dist
Vcs:           https://github.com/eserte/perl-tk.git

Source:        %name-%version.tar
BuildRequires: perl-devel >= 5.38.4-alt2
BuildRequires: libXft-devel
BuildRequires: libjpeg-devel
BuildRequires: libpng-devel
BuildRequires: perl-Devel-Leak
BuildRequires: perl-Encode
BuildRequires: imake
BuildRequires: xprop
BuildRequires: xvfb-run
BuildRequires: libXcursor
BuildRequires: fonts-ttf-dejavu
BuildRequires: fonts-type1-urw
Provides:      cpan(tk) = %version

Provides:      perl-Tk = %EVR
Provides:      perl-Tk-JPEG = %EVR
Obsoletes:     perl-Tk < %EVR
Obsoletes:     perl-Tk-JPEG < %EVR
# provides for demos are useless
%add_findprov_skiplist %perl_vendor_archlib/Tk/demos/*/*.pl
%add_findreq_skiplist %perl_vendor_archlib/Tk/demos/widget_lib/*.pl
%add_findreq_skiplist %perl_vendor_archlib/Tk/demos/widtrib/*.pl

# fix for deparse failure
%define __spec_autodep_custom_pre export PERL5OPT='-I%buildroot%perl_vendor_archlib -MTk'
%define _perl_lib_path %perl_vendor_archlib/Tk/demos/widget_lib

%description
This is a set of Perl modules which provide access to the Tk library,
a Graphical User Interface ToolKit.


%package       demos
Summary:       Perl modules providing the Tk graphics library
Group:         Development/Perl
Requires:      %name = %EVR

%description   demos
This is a set of Perl modules which provide access to the Tk library,
a Graphical User Interface ToolKit.


%package       devel
Summary:       Perl modules providing the Tk graphics library
License:       TCL and Artistic-1.0 or GPL-2.0-or-later
Group:         Development/Perl
Requires:      %name = %EVR
Provides:      cpan{tk} = %version
Provides:      perl-Tk-devel = %EVR
Obsoletes:     perl-Tk-devel < %EVR

%description   devel
This is a set of Perl modules which provide access to the Tk library,
a Graphical User Interface ToolKit.


%prep
%setup -q
rm -r PNG/zlib/ PNG/libpng/

# font-dependent tests, see README
rm t/entry.t t/listbox.t

%ifdef __buildreqs
rm t/dirtree.t
%endif

# XXX fails under Xvfb in hasher
rm t/fileevent2.t

cd pTk
for f in license.*; do
mv "$f" "Tk.$f"
done
cd -

%perl_vendor_build %{?_with_xft:XFT=1} X11LIB=%_x11libdir

%install
%perl_vendor_install

%check
xvfb-run -a make test


%files
%doc README README.linux Funcs.doc ToDo Changes README-ActiveState.txt README-Strawberry.txt README.AIX README.HPUX README.IRIX README.OSF README.OpenBSD README.SCO README.SVR4 README.Solaris README.cygwin README.darwin README.os2 README.ultrix examples
	%_bindir/ptked
	%_bindir/ptksh
	%_bindir/tkjpeg
	%perl_vendor_archlib/Tie*
	%perl_vendor_archlib/Tk*
	%perl_vendor_autolib/Tk*
%exclude %perl_vendor_archlib/Tk/demos
%exclude %perl_vendor_archlib/Tk/pTk*
%exclude %perl_vendor_archlib/Tk/*.def
%exclude %perl_vendor_archlib/Tk/*.[hmt]
%exclude %perl_vendor_archlib/Tk/typemap
%exclude %perl_vendor_archlib/Tk/MakeDepend.pm
%exclude %perl_vendor_archlib/Tk/MMutil.pm

%files devel
%doc README README.linux pTk/*license*
%dir	%perl_vendor_archlib/Tk
	%perl_vendor_archlib/Tk/pTk*
	%perl_vendor_archlib/Tk/*.def
	%perl_vendor_archlib/Tk/*.[hmt]
	%perl_vendor_archlib/Tk/typemap
	%perl_vendor_archlib/Tk/MakeDepend.pm
	%perl_vendor_archlib/Tk/MMutil.pm

%files demos
%doc	demos/README
	%_bindir/gedi
	%_bindir/widget
%dir	%perl_vendor_archlib/Tk
%dir	%perl_vendor_archlib/Tk/demos
	%perl_vendor_archlib/Tk/demos/*.pm
	%perl_vendor_archlib/Tk/demos/images/
	%perl_vendor_archlib/Tk/demos/widget_lib/
	%perl_vendor_archlib/Tk/demos/widtrib/


%changelog
