%define _unpackaged_files_terminate_build 1
Name: perl-Wx
Version: 0.9932
Release: alt4

Summary: wxPerl - Perl bindings for wxWindows
License: GPL+ or Artistic
Group: Development/Perl

URL: http://wxperl.sourceforge.net/
Source0: http://www.cpan.org/authors/id/M/MD/MDOOTSON/Wx-%{version}.tar.gz
# Work around BOM_UTF8 clash between wxGTK and Perl. Should be fixed in newer
# wxGTK, CPAN RT#121464, <http://trac.wxwidgets.org/ticket/13599>.
Patch0:         Wx-0.9932-Undefine-BOM_UTF8.patch
Patch1:         gtk3.patch
Patch2:         wxWidgets_3.2_MakeMaker.patch
Patch3:         wxWidgets_3.2_port.patch    

BuildPrereq: dos2unix

# Automatically added by buildreq on Wed Oct 19 2011
BuildRequires: gcc-c++ perl-Encode perl-ExtUtils-CBuilder perl-ExtUtils-XSpp perl-IO-String perl-autodie perl-threads xvfb-run

%description
wxPerl is a Perl module wrapping the awesome wxWindows library
for cross-platform GUI developement.

%package devel
Summary: Wx Perl development files
Group: Development/Perl
Requires: %name = %version-%release
BuildRequires: libwxGTK3.2-devel perl-Alien-wxWidgets
Requires: libwxGTK3.2-devel

%description devel
Development files useful for building Perl applications depending on Wx.

%prep
%setup -q -n Wx-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1

# Hooray for line ending differences.
dos2unix MANIFEST
dos2unix typemap

%patch3 -p1

%ifdef __buildreqs
# these tests open /usr/share/applications/*.desktop
rm t/08_ovl_func.t
rm ext/filesys/t/03_threads.t
%endif

%ifndef _build_display
%def_without test
%endif

%build
%if 1
%perl_vendor_build
%else
# with --wx-unicode
perl Makefile.PL --wx-unicode \
  --wx-version=`wx-config --version | cut -d . -f 1-2` \
  --wx-toolkit=gtk \
  INSTALLDIRS=vendor \
  OPTIMIZE="$RPM_OPT_FLAGS -Wno-unused-variable -Wno-unused-but-set-variable -Wno-unused-local-typedefs"
%make_build
%endif

%install
%perl_vendor_install

%check
xvfb-run -a make test

# need DISPLAY for perl.req
%{expand:%%global __find_requires xvfb-run -a %__find_requires}

%files
%doc README.txt wxpl.ico wxpl.xpm Changes docs
%perl_vendor_archlib/Wx*
%perl_vendor_autolib/Wx
%exclude %perl_vendor_archlib/Wx/Overload
%exclude %perl_vendor_archlib/Wx/build
%exclude %perl_vendor_archlib/Wx/cpp
%exclude %perl_vendor_archlib/Wx/typemap

%files devel
%doc Changes samples
%_bindir/wx*
%_man1dir/wxperl_overload.*
%dir %perl_vendor_archlib/Wx
%perl_vendor_archlib/Wx/Overload
%perl_vendor_archlib/Wx/build
%perl_vendor_archlib/Wx/cpp
%perl_vendor_archlib/Wx/typemap

%changelog
