# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Test-Vars
%define upstream_version 0.017

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Detects unused variables
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Test/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(B.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(ExtUtils/Manifest.pm)
BuildRequires: perl(File/Spec/Functions.pm)
BuildRequires: perl(IO/Pipe.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(Moose/Role.pm)
BuildRequires: perl(Storable.pm)
BuildRequires: perl(Symbol.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Output.pm)
BuildRequires: perl(Test/Tester.pm)
BuildRequires: perl(parent.pm)
BuildArch:  noarch
Source44: import.info

%description
Test::Vars finds unused variables in order to keep the source code tidy.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml example
%{perl_vendor_privlib}/*

%changelog
