# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Test-UseAllModules
Version:        0.17
Release:        alt1_10
Summary:        Do use_ok() for all the MANIFESTed modules
License:        GPL+ or Artistic
Group:          Development/Other
URL:            https://metacpan.org/release/Test-UseAllModules
Source0:        https://cpan.metacpan.org/authors/id/I/IS/ISHIGAKI/Test-UseAllModules-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(ExtUtils/Manifest.pm)
# perl(Test::Builder) needed for lib/Test/UseAllModules.pm:52:
# Test::More->builder->has_plan;
BuildRequires:  perl(Test/Builder.pm)
BuildRequires:  perl(Test/More.pm)
# Tests only:
BuildRequires:  perl(FindBin.pm)
BuildRequires:  perl(lib.pm)
# Optional tests:
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
Requires:       perl(Test/Builder.pm) >= 0.300
Requires:       perl(Test/More.pm) >= 0.600

# Remove underspecifies dependencies

Source44: import.info
%filter_from_requires /perl(Test.More.pm)/d

%description
I'm sick of writing 00_load.t (or something like that) that will do use_ok()
for every module I write. I'm sicker of updating 00_load.t when I add
another file to the distribution. This module reads MANIFEST to find modules
to be tested and does use_ok() for each of them. Now all you have to do is
update MANIFEST. You don't have to modify the test any more (hopefully).

%prep
%setup -q -n Test-UseAllModules-%{version}
for F in Changes README; do
    tr -d '\r' <"$F" >"$F.unix"
    touch -r "$F"{,.unix}
    mv "${F}"{.unix,}
done

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
TEST_POD=1 make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
