Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		perl-Parallel-Runner
Version:	0.014
Release:	alt1_3
Summary:	An object to manage running things in parallel processes
License:	GPL-1.0-or-later OR Artistic-1.0-Perl
URL:		https://metacpan.org/release/Parallel-Runner
Source0:	https://cpan.metacpan.org/authors/id/E/EX/EXODIST/Parallel-Runner-%{version}.tar.gz
BuildArch:	noarch
# Module Build
BuildRequires:	coreutils
BuildRequires:	findutils
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
# Module Runtime
BuildRequires:	perl(Carp.pm)
BuildRequires:	perl(Child.pm)
BuildRequires:	perl(POSIX.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(Time/HiRes.pm)
BuildRequires:	perl(warnings.pm)
# Test Suite
BuildRequires:	perl(Test2/IPC.pm)
BuildRequires:	perl(Test2/V0.pm)
Source44: import.info
# Dependencies
# (none)

%description
There are several other modules to do this, you probably want one of them. This
module exists as a super-specialized parallel task manager. You create the
object with a process limit and callbacks for what to do while waiting for a
free process slot, as well as a callback for what a process should do just
before exiting.

You must explicitly call $runner->finish() when you are done. If the runner is
destroyed before its children are finished, a warning will be generated and
your child processes will be killed, by force if necessary.

If you specify a maximum of 1 then no forking will occur, and run() will block
until the coderef returns. You can force a fork by providing a boolean true
value as the second argument to run(), which will force the runner to fork
before running the coderef; however, run() will still block until the child
exits.

%prep
%setup -q -n Parallel-Runner-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} -c %{buildroot}

%check
RUN_KILL_TESTS=1 make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_privlib}/Parallel/

%changelog
