Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl rpm-build-licenses
BuildRequires: perl(CGI.pm) perl(CGI/Carp.pm) perl-podlators
# END SourceDeps(oneline)
%define fontpkgname perl-MIME-Lite-HTML
Name:           perl-MIME-Lite-HTML
Version:        1.24
Release:        alt3
Summary:        Provide routine to transform a HTML page in a MIME-Lite mail
License:        %perl_license
URL:            https://metacpan.org/release/MIME-Lite-HTML
Source0:        https://cpan.metacpan.org/modules/by-module/MIME/MIME-Lite-HTML-%{version}.tar
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  glibc-core glibc-timezones glibc-utils iconv
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(HTML/LinkExtor.pm)
BuildRequires:  perl(LWP/UserAgent.pm)
BuildRequires:  perl(MIME/Lite.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(URI/URL.pm)
BuildRequires:  perl(vars.pm)
# Tests:
BuildRequires:  perl(Test.pm)

%description
This module is a Perl mail client interface for sending message that
support HTML format and build them for you.. This module provides routine to
transform an HTML page in a MIME::Lite mail. So you need this module to use
MIME-Lite-HTML possibilities.


%prep
%setup -q -n MIME-Lite-HTML-%{version}
chmod a-x README Changes HTML.pm
iconv -f iso8859-1 -t utf-8 Changes > Changes.utf8 && \
touch -r Changes Changes.utf8 && \
mv -f Changes.utf8 Changes
# The 2 following tests are broken by MIME::Lite 3.029
# Headers order is not quaranteed so relying on that to test the module is
# doomed to fail.
# Relevant bugs :
# MIME::Lite::HTML : http://rt.cpan.org/Public/Bug/Display.html?id=86020
# MIME::Lite : https://rt.cpan.org/Public/Bug/Display.html?id=79944
rm -f t/20create_image_part.t t/50generic.t

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes COPYING README
%perl_vendor_privlib/*


%changelog
