%define _unpackaged_files_terminate_build 1
%define module_name JSON-Parse
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(XSLoader.pm)
# END SourceDeps(oneline)
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.62
Release: alt1
Summary: Read JSON into a Perl variable
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://www.cpan.org/authors/id/B/BK/BKB/%{module_name}-%{version}.tar.gz

%description
A module for parsing JSON. (JSON means "JavaScript Object Notation"
and it is specified in the RFC 7159 entry elsewhere in this document.)

JSON::Parse offers the function the parse_json entry elsewhere in this document, which takes a string
containing JSON, and returns an equivalent Perl structure. It also
offers validation of JSON via the valid_json entry elsewhere in this document, which returns true or
false depending on whether the JSON is correct or not, and
the assert_valid_json entry elsewhere in this document, which produces a descriptive fatal error if the
JSON is invalid. A function the json_file_to_perl entry elsewhere in this document reads JSON from a
file, and there is a safer version of the parse_json entry elsewhere in this document called
the parse_json_safe entry elsewhere in this document which doesn't throw exceptions.

For special cases of parsing, there are also methods the new entry elsewhere in this document and
the run entry elsewhere in this document, which create a JSON parsing object and run it on text. See
the METHODS entry elsewhere in this document.

JSON::Parse accepts only UTF-8 as input. See the UTF-8 only entry elsewhere in this document and
the Handling of Unicode entry elsewhere in this document.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release
BuildArch: noarch

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples CONTRIBUTING.md
%perl_vendor_archlib/J*
%perl_vendor_autolib/*

%files scripts
%_bindir/*

%changelog
