%def_with utils
%define module Gear-Remotes

Name: perl-%module
Version: 0.037
Release: alt1
BuildArch: noarch
Packager: Igor Yu. Vlasenko <viy@altlinux.org>

Summary: %module - Perl extension for quering Gear remotes files
Group: Development/Perl
License: GPLv2+ or Artistic-2.0
Source: http://www.cpan.org/modules/by-module/RPM/%module-%version.tar.gz
# TODO: upload to http://search.cpan.org/dist/%module
Url: https://www.altlinux.org/Gear/remotes

# Automatically added by buildreq on Wed Nov 06 2002
BuildRequires: perl-devel perl(Pod/Usage.pm) perl(Pod/Text.pm) perl(RPM/uscan.pm) perl(Gear/Rules.pm) perl(RPM/Source/Editor.pm) perl(RPM/Devscripts/Versort.pm)
Requires: gear perl(Pod/Text.pm)
%if_without utils
Provides: gear-remotes = %version
Provides: gear-remotes-utils = %version
Requires: gear-uupdate
%endif

%description
Perl library and tools to work with .gear/upstream/remotes files.
Gear is a tool for storing, building and maintaining rpm packages
in a git repository for ALT Linux team.

Gear, however, lack means to store essential parts of local configuration,
such as location of upstream VCS it was cloned from or updated.
.gear/upstream/remotes is an extension to Gear to cover this weakness.

See more on [www.altlinux.org/Gear/remotes].

%if_with utils
%package -n gear-remotes-utils
Summary: utilities for manipulating Gear upstream/remotes files
Group: Development/Other
Requires: perl-Gear-Remotes = %EVR
Requires: gear-uupdate
Provides: gear-remotes = %version
Obsoletes: perl-Gear-Remotes < 0.024
Conflicts: perl-Gear-Remotes < 0.024

%description -n gear-remotes-utils
gear-remotes-utils are utils for managing .gear/upstream/remotes file.
.gear/upstream/remotes file is used to save, share and restore local
.git configuration to all maintainers.
%endif

%package -n gear-remotes-batch-watch
Summary: utilities for batch quering for updates from rpm git urls
Group: Development/Other
Requires: perl-Gear-Remotes = %EVR
Requires: /usr/bin/altlinux-find-local-mirror
BuildRequires: perl(Parallel/ForkManager.pm)

%description -n gear-remotes-batch-watch
gear-remotes-batch-watch utils are used for batch quering for updates
from rpm git urls found in VCS: and URL: rpm tags.

%prep
%setup -q -n %module-%version

%build
%perl_vendor_build

%install
%perl_vendor_install

ln -s gr-batch-watch-standalone %buildroot%_bindir/repocop-watch-batch-git-plugin

%files
#doc Changes
#doc README
%perl_vendor_privlib/G*
%if_with utils
%files -n gear-remotes-utils
%endif
%_bindir/gear-remotes-*
%_man1dir/gear-remotes-*

%files -n gear-remotes-batch-watch
%_bindir/gr-batch-*
%_man1dir/gr-batch-*
%_bindir/repocop-watch-*

%changelog
