%define _unpackaged_files_terminate_build 1
%set_perl_req_method relaxed
%ifarch ppc64le
%define _without_test 1
%endif
%define module_name Future-IO
%define test_module_name Test-Future-IO-Impl
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Future.pm) perl(Module/Build.pm) perl(Struct/Dumb.pm) perl(Test/ExpectAndCheck.pm) perl(Test/Future/IO/Impl.pm) perl(Test/Identity.pm) perl(Test/More.pm) perl(Test2/V0.pm) perl(Time/HiRes.pm) perl(experimental.pm)
# END SourceDeps(oneline)
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.16
Release: alt1
Summary: Future-returning IO methods
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://www.cpan.org/authors/id/P/PE/PEVANS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This package provides a few basic methods that behave similarly to the
same-named core perl functions relating to IO operations, but yield their
results asynchronously via the Future manpage instances.

This is provided primarily as a decoupling mechanism, to allow modules to be
written that perform IO in an asynchronous manner to depend directly on this,
while allowing asynchronous event systems to provide an implementation of
these operations.


%package -n perl-%{test_module_name}
Summary: acceptance tests for Future::IO implementations
Group: Development/Perl

%description -n perl-%{test_module_name}
This module contains a collection of acceptance tests for implementations of Future::IO

%prep
%setup -q -n %{module_name}-%{version}

# ifarch ppc64le define _without_test 1 does not work for noarch :(
case `uname -m` in
    ppc64*|loongarch*)
    # hangs
    #rm -f t/04syswrite.t ?
    rm -f t/0[4-9]*.t
    ;;
esac

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/F*

%if 0
%files -n perl-%{test_module_name}
%perl_vendor_privlib/Test*
%endif

%changelog
