%define _unpackaged_files_terminate_build 1
Epoch: 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Scalar/Util.pm) perl(XSLoader.pm) perl-devel perl-podlators
# END SourceDeps(oneline)
Name:           perl-Devel-FindRef
Version:        1.46
Release:        alt1.1
Summary:        Where is that reference to my variable hiding?
License:        GPL+ or Artistic
Group:          Development/Perl
URL:            http://search.cpan.org/dist/Devel-FindRef/
Source0:        http://www.cpan.org/authors/id/M/ML/MLEHMANN/Devel-FindRef-%{version}.tar.gz
# fixing format warnings
Patch0:         perl-Devel-FindRef-1.44-fix-format-warnings.patch
# https://bugzilla.redhat.com/show_bug.cgi?id=786085
Patch2:         Devel-FindRef-fix.patch
BuildRequires:  perl(ExtUtils/MakeMaker.pm) perl(Canary/Stability.pm)
BuildRequires:  perl(common/sense.pm)
Source44: import.info

%description
Tracking down reference problems (e.g. you expect some object to be
destroyed, but there are still references to it that keep it alive) can be
very hard. Fortunately, perl keeps track of all its values, so tracking
references "backwards" is usually possible.

%prep
%setup -q -n Devel-FindRef-%{version}
%patch0 -p1
%patch2 -p1

%build
# remove me in proper upstream release
#[ %version = 1.44 ] || exit 3
%define _without_test 1
# end remove

yes | perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="$RPM_OPT_FLAGS"
make %{?_smp_mflags}

%install

make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT

find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -type f -name '*.bs' -size 0 -exec rm -f {} \;
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;

%check
make test

%files
%doc Changes COPYING README
%{perl_vendor_archlib}/auto/Devel
%{perl_vendor_archlib}/Devel

%changelog
