%define _unpackaged_files_terminate_build 1
Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Runtime.pm) perl(Test/Pod/Coverage/TrustMe.pm) perl(Types/Standard.pm) perl-podlators
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		perl-CPAN-Changes
Summary:	Read and write Changes files
Version:	0.500005
Release:	alt1
License:	GPL+ or Artistic
URL:		https://metacpan.org/release/CPAN-Changes
Source0:	http://www.cpan.org/authors/id/H/HA/HAARG/CPAN-Changes-%{version}.tar.gz
BuildArch:	noarch
# Module Build
BuildRequires:	coreutils
BuildRequires:	findutils
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
# Module Runtime
BuildRequires:	perl(Encode.pm)
BuildRequires:	perl(Scalar/Util.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(Test/Builder.pm)
BuildRequires:	perl(Text/Wrap.pm)
BuildRequires:	perl(version.pm)
BuildRequires:	perl(warnings.pm)
# Script Runtime
BuildRequires:	perl(Getopt/Long.pm)
BuildRequires:	perl(Pod/Usage.pm)
# Test Suite
BuildRequires:	perl(Test/More.pm)
# Optional Tests
%if 0%{?fedora:1}
BuildRequires:	perl(Moo.pm)
%endif
# Extra Tests
BuildRequires:	perl(Test/Pod.pm)
BuildRequires:	perl(Test/Pod/Coverage.pm)
# Runtime
Requires:	perl(version.pm) >= 0.99.06
Source44: import.info

%description
It is standard practice to include a Changes file in your distribution. The
purpose of the Changes file is to help a user figure out what has changed
since the last release.

People have devised many ways to write the Changes file. A preliminary
specification has been created (CPAN::Changes::Spec) to encourage module
authors to write clear and concise Changes.

This module will help users programmatically read and write Changes files
that conform to the specification.

%prep
%setup -q -n CPAN-Changes-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} -c %{buildroot}

%check
make test
make test TEST_FILES="$(echo $(find xt/ -name '*.t'))"

%files
%doc Changes README
%{_bindir}/tidy_changelog
%{perl_vendor_privlib}/CPAN/
%{perl_vendor_privlib}/Test/
%{_mandir}/man1/tidy_changelog.1*

%changelog
