%define _unpackaged_files_terminate_build 1
%define bootstrap_tagset %nil
#define bootstrap_tagset AutoReqProv: yes,noperl
%def_without boorstrap_perl_wrapper


Name: perl
Version: 5.38.4
Release: alt3
Epoch: 1

Summary: Practical Extraction and Report Language
License: Artistic-1.0 OR GPL-2.0-or-later
Group: Development/Perl

Url: http://www.perl.org
Packager: Perl Maintainers Team <cpan@packages.altlinux.org>
Source: perl-%version.tar

Patch01: perl-5.34.0-alt-644-at-ExtUtils-Install.patch
Patch02: perl-5.24.0-alt-644-at-installperl.patch
Patch03: perl-5.22.0-alt-644-viy-ExtUtils-Install-fix-test.patch
Patch04: perl-5.26.1-alt-at-MM_Unix-link-xs-with-libperl.patch
Patch05: perl-5.24.1-alt-at-MM_Unix-shabang.patch
Patch06: perl-5.32.1-alt-at-Storable-no-early-dep-on-Log-Agent.patch
Patch07: perl-5.24.0-alt-at-debian-Errno_pm.patch
Patch08: perl-5.26.1-alt-at-disable-Cpan-Meta-under-rpm.patch
Patch09: perl-5.24.0-alt-at-libperl-soname.patch
Patch10: perl-5.34.0-alt-at-no-rpath-for-std-libs.patch
Patch11: perl-5.20.1-alt-at-perl5db-findreq-cleanup.patch
Patch12: perl-5.20.1-alt-at-perlbug-findreq-cleanup.patch
Patch13: perl-5.20.1-alt-at-skip-deprecation-warning.patch
Patch14: perl-5.20.1-alt-crux-Cwd-use-realpath.patch
# or hsh with --mountpoints=/proc
Patch15: perl-5.20.1-alt-crux-fix-test-without-proc.patch
Patch16: perl-5.20.1-alt-ldv-support-for-alt-gcc-wrapper.patch
Patch17: perl-5.26.1-alt-viy-Unicode-Normalize-fix-deps.patch
# hack - sensitive test can fail transaction - see maintainers notes for 5.24.1
Patch18: perl-5.32.1-alt-viy-disable-Time-HiRes-itimer.t.patch
Patch19: perl-5.28.1-alt-viy-no-check-sums-in-customized.t.patch
# temporary quick hack; should be replaced by a proper surgery
# not installing version::regex will create perl.req's unmets
Patch20: perl-5.24.1-alt-viy-installperl-ExtUtils-MakeMaker-version.patch
# mail from Oleg Solovyov; see patch body
Patch21: perl-5.24.3-alt-solovyov.patch
# asked mcpain@. 2023-10-18 he still needs this hack
# wait for resolution
#Patch22: perl-5.38.0-alt-mcpain-trust-mode.patch
Patch23: perl-5.38.0-alt-e2k-bitfields.patch
# hack;
# Perl lib version (5.38.4) doesn't match executable '/usr/src/tmp/perl-buildroot/usr/bin/perl5.38.4' version (5.38.2) at /usr/src/tmp/perl-buildroot/usr/lib64/perl5/Config.pm line 62.
Source24: perl-5.38.4-alt-Config.pm-hack.patch

# cpan update patches here. use format below:
#Patch50: cpan-update-Scalar-List-Utils-1.55-to-Scalar-List-Utils-1.56.patch

# ------ inserted with srpm-spec-inject-patches(1) -------
# BeginPatches(fedora)[shift=300]: -----------------------

# Make *DBM_File desctructors thread-safe, bug #1107543, RT#61912
Patch310:        perl-5.34.0-Destroy-GDBM-NDBM-ODBM-SDBM-_File-objects-only-from-.patch

# Link XS modules to pthread library to fix linking with -z defs,
# <https://lists.fedoraproject.org/archives/list/devel@lists.fedoraproject.org/message/3RHZEHLRUHJFF2XGHI5RB6YPDNLDR4HG/>
Patch312:        perl-5.27.8-hints-linux-Add-lphtread-to-lddlflags.patch

# Pass the correct CFLAGS to dtrace
Patch313:        perl-5.28.0-Pass-CFLAGS-to-dtrace.patch

# Fix broken certain locale-related functionality when embedding Perl code
# into a C program. Bug #2240458, GH #21366
# Backported perl5 commit 7af2d20
# Fixed in perl 5.39.3, in locale.c was more changes
Patch314:         perl-5.38.0-Revert-Do-uselocale-earlier-in-init-process.patch

# If optimizing -O is used, add the definition to .ph files, bug #2152012
Patch502:       perl-5.36.0-Add-definition-of-OPTIMIZE-to-.ph-files.patch
# EndPatches(fedora): --------------------------------------
Patch503:       perl-5.38.4-incompatible-pointer-fix-for-svpv-helper.patch

# there's a problem with strict.pm
%add_findreq_skiplist */strict.pm
# the failure for bytes_heavy.pl is normal, it's not self-contained
%add_findreq_skiplist */bytes_heavy.pl
# skip Compress::Zlib and Encode dependencies
%add_findreq_skiplist */DBM_Filter/*.pm
# Data::Dumper uses B::Deparse (on demand) to store coderefs
%add_findreq_skiplist */Data/Dumper.pm
# open.pm requires Encode in certain cases
%add_findreq_skiplist */open.pm
# It requires Encode which we split out
%add_findreq_skiplist */ExtUtils/MakeMaker.pm
%add_findreq_skiplist */ExtUtils/MakeMaker/Locale.pm
# It requires Term::Readline which is moved to Term-Readline-Gnu
%add_findreq_skiplist */perl5db.pl

# do not provide auxiliary unicore libraries
%add_findprov_skiplist */unicore/*/*

# Pod-Html requires Pod-Simple, moved to subpackage
%add_findreq_skiplist */Pod/Html/Util.pm
%add_findreq_skiplist */Pod/Html.pm
%add_findreq_skiplist */pod2html


BuildRequires: /proc

%bootstrap_tagset

%package base
Summary: Pathologically Eclectic Rubbish Lister
Group: System/Base
Provides: perl = %epoch:%version
Obsoletes: perl < %epoch:%version
Provides: perl-PerlIO = %epoch:%version perl-Storable = %epoch:%version
Obsoletes: perl-PerlIO < %epoch:%version perl-Storable < %epoch:%version
Provides: perl-version = 0.99
Obsoletes: perl-version < 0.99
Provides: perl-Digest-MD5 = 2.57
Obsoletes: perl-Digest-MD5 < 2.55
Provides: perl-Time-HiRes = 1.976
Obsoletes: perl-Time-HiRes < 1.9741
Provides: perl-MIME-Base64 = 3.16
Obsoletes: perl-MIME-Base64 < 3.15
Provides: perl-IPC-SysV = 2.09
Obsoletes: perl-IPC-SysV < 2.08
Provides: perl-PathTools = 3.75
Obsoletes: perl-PathTools < 3.75-alt2
# for compatibility with other distro
Provides: perl-Data-Dumper = 2.188
# autoimports
Conflicts: perl-builtin-Backport < 0.03
%bootstrap_tagset

%package devel
Summary: Perl header files and development modules
Group: Development/Perl
Requires: perl-base = %EVR
Provides: perl-Test-Tester = 0.114
Obsoletes: perl-Test-Tester < 0.114
Conflicts: perl-Test-Tester < 0.114
Provides: perl-Test-use-ok = 0.12
Obsoletes: perl-Test-use-ok < 0.12
Conflicts: perl-Test-use-ok < 0.12
Provides: perl-Test2 = 0.000045
Obsoletes: perl-Test2 < 0.000045
Conflicts: perl-Test2 < 0.000045

%define libdb_devel libdb5.3-devel
BuildRequires: %libdb_devel libgdbm-devel
# perl IO-AIO module pass perl link options to configure.
# without those devel libs configure fails.
#Requires: %libdb_devel
Requires: libgdbm-devel
%bootstrap_tagset

%package pod
Summary: Perl documentation
Group: Development/Documentation
Requires: perl-base = %epoch:%version
Provides: perl-doc = %epoch:%version
BuildArch: noarch
%bootstrap_tagset

%package threads
Summary: Perl thread modules
Group: Development/Perl
Requires: perl-base = %EVR
%bootstrap_tagset

%package unicore
Summary: Perl Unicode library
Group: Development/Perl
Requires: perl-Unicode-Normalize = %EVR
BuildArch: noarch
%bootstrap_tagset

%package DBM
Summary: Perl modules for accessing DBM databases
Group: Development/Perl
Requires: perl-base = %EVR
Provides:  perl-DB_File
Obsoletes: perl-DB_File
%bootstrap_tagset

%package Unicode-Normalize
Summary: Unicode normalization forms
Group: Development/Perl
Requires: perl-base = %EVR
%bootstrap_tagset

%package Pod-Html
Summary: Convert pod files to HTML
Group: Development/Perl
BuildArch: noarch
Requires: perl-base = %EVR
Requires: perl-Pod-Simple
Conflicts: perl-base < 1:5.37
%bootstrap_tagset

%package diagnostics
Summary: Produce verbose warning diagnostics
Group: Development/Perl
BuildArch: noarch
Requires: perl-base = %EVR
Conflicts: perl-base <= 1:5.38.2-alt0.1
%bootstrap_tagset


%description
Perl is a high-level programming language with roots in C, sed, awk
and shell scripting.  Perl is good at handling processes and files,
and is especially good at handling text.  Perl's hallmarks are
practicality and efficiency.  While it is used to do a lot of
different things, Perl's most common applications (and what it excels
at) are probably system administration utilities and web programming.
A large proportion of the CGI scripts on the web are written in Perl.

%description base
Perl is a high-level programming language with roots in C, sed, awk
and shell scripting.  Perl is good at handling processes and files,
and is especially good at handling text.  Perl's hallmarks are
practicality and efficiency.  While it is used to do a lot of
different things, Perl's most common applications (and what it excels
at) are probably system administration utilities and web programming.
A large proportion of the CGI scripts on the web are written in Perl.

This package provides Perl interpreter and a subset of the standard
library required to perform basic tasks.

%description devel
This package contains Perl header files and development modules.
Most perl packages will need to install perl-devel to build.

%description pod
This package provides standard Perl documentation in Pod format.

%description threads
This package provides Perl modules for thread programming.  The threads
module provides interface to interpreter-based threading implementation
(ithreads).  The threads::shared module enables data sharing between
threads.  Thread::Queue and Thread::Semaphore provide thread-safe
synchronization primitives.

%description unicore
This package provides extended Unicode support for Perl (full support
for Unicode properties in regular expressions, Unicode Character Database,
the Unicode::UCD module, and the charnames pragma).

%description DBM
This package provides Perl modules for accessing DBM databases.
AnyDBM_File provides a framework for multiple DBM implementations
(DB_File, NDBM_File, GDBM_File, and SDBM_File). DBM_Filter allows
filtering DBM keys/values by user-defined code.

%description Unicode-Normalize
This module provides support for normalized forms of Unicode text,
as described in Unicode Standard Annex #15.  With these forms,
equivalent text will have identical binary representations.

%description Pod-Html
This module converts files from pod format (see perlpod) to HTML format.
It can automatically generate indexes and cross-references, and it keeps
a cache of things it knows how to cross-reference.

%description diagnostics
The diagnostics module extends the terse diagnostics normally emitted by both
the perl compiler and the perl interpreter (from running perl with a -w switch
or "use warnings"), augmenting them with the more explicative and endearing
descriptions found in perldiag. splain tool explains perl messages found on
standard input.


%prep
%setup -q
%patch01 -p1
%patch02 -p1
%patch03 -p1
%patch04 -p1
%patch05 -p1
%patch06 -p1
%patch07 -p1
%patch08 -p1
%patch09 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1
%patch21 -p1
# patch22 needs groking
#patch22 -p1
%ifarch %e2k
%patch23 -p1
%endif
#patch50 -p1
%patch503

# ------ inserted with srpm-spec-inject-patches(1) -------
# BeginPatches(fedora): ------------------------------------
# EndPatches(fedora): --------------------------------------

# .orig files can break some test
# at least t/porting/readme.t :
# Failed test 39 - Maintainers.pl.orig is mentioned in Porting/README.pod at porting/readme.t line 36
find -name '*.orig' -delete

%build
%define ver %(v=%version IFS=.; set $v; echo $1.$2)
%define privlib /usr/share/perl5
%define archlib %_libdir/perl5
%define autolib %archlib/auto
%define site_prefix %_prefix/local
%define site_privlib %site_prefix/share/perl/%ver
%define site_archlib %site_prefix/%_lib/perl/%ver

sh Configure -ders \
	-Duse64bitint \
	-Dusethreads -Duseithreads -Duselargefiles \
	-Duseshrplib -Dlibperl=libperl-%ver.so \
	-Dcc=gcc -Doptimize="%optflags" -DDEBUGGING=maybe \
	-Dprefix=%_prefix -Dprivlib=%privlib -Darchlib=%archlib \
	-Dvendorprefix=%_prefix -Dvendorlib=%privlib -Dvendorarch=%archlib \
	-Dsiteprefix=%site_prefix -Dsitelib=%site_privlib -Dsitearch=%site_archlib \
	-Dotherlibdirs=/etc/perl5:/usr/lib/perl5/vendor_perl \
	-Dinc_version_list=none \
	-Dpager='%_bindir/less -isR' \
	-Dman1dir=%_man1dir -Dman3dir=none \
	-Dcf_by='%vendor' -Dcf_email='%packager' \
	-Dmyhostname=localhost -Dperladmin=root@localhost

# kill rpath
sed -i 's@ -Wl,-rpath,%archlib/CORE@@g' config.sh [Mm]akefile myconfig

# fixup man1ext and man3ext
sed -i '/man1ext/{s/0/1/}' config.sh [Mm]akefile
sed -i '/man3ext/{s/0/3pm/}' config.sh [Mm]akefile

# make -lperl symlink
ln -snf libperl-%ver.so libperl.so

# build the rest (SMP incompatible on: sparc64 %%arm, according to fedora)
make

# deprecated; see https://bugzilla.altlinux.org/40649
%ifarch %e2k
## http://bugzilla.altlinux.org/35523 workaround
#rm -f regexec.o libperl-%ver.so ext/re/re_exec.o
#make OPTIMIZE+='%optflags -O1' regexec.o
#make libperl-%ver.so
#make -C ext/re OPTIMIZE+='%optflags -O1' re_exec.o
#make -C ext/re all
%endif

%if "%version" == "5.38.4"
# ugly hack for buildroot
# Perl lib version (5.38.2) doesn't match executable 'buildroot/usr/bin/perl5.38.2' version (5.38.0) at buildroot/usr/lib64/perl5/Config.pm line 62.
patch -p1 < %{SOURCE24}
%endif

%check
export LD_LIBRARY_PATH=$PWD LD_BIND_NOW=1 PERL_DL_NONLAZY=1
# for perl 5.26.2; hack around t/porting/regen.t
%global build_privlib     %buildroot%{_prefix}/share/perl5
%global build_archlib     %buildroot%{_libdir}/perl5
%global build_bindir      %buildroot%{_bindir}
%global new_perl LD_PRELOAD="%{build_archlib}/CORE/libperl.so" LD_LIBRARY_PATH="%{build_archlib}/CORE" PERL5LIB="%{build_archlib}:%{build_privlib}" %{build_bindir}/perl
%new_perl -I/lib regen/lib_cleanup.pl
pushd t
%new_perl -I../lib porting/customized.t --regen
popd
# end hack
#make test
make test_harness

%install
%make_install install.perl DESTDIR=%buildroot

# use symlinks instead of hardlinks
ln -snf perl%version %buildroot%_bindir/perl
ln -snf perl%version %buildroot%_bindir/perl5

# skeleton
mkdir -p %buildroot%privlib/auto
mkdir -p %buildroot/etc/perl5
mkdir -p %buildroot/usr/lib/perl5/vendor_perl

# relocate libperl
mv %buildroot%archlib/CORE/libperl-%ver.so %buildroot%_libdir/
ln -snf `relative %_libdir/libperl-%ver.so %archlib/CORE/libperl.so` %buildroot%archlib/CORE/libperl.so
ln -snf `relative %_libdir/libperl-%ver.so %archlib/CORE/libperl-%ver.so` %buildroot%archlib/CORE/libperl-%ver.so

# relocate Config.pod and POSIX.pod
mv %buildroot{%archlib,%privlib}/Config.pod
mv %buildroot{%archlib,%privlib}/POSIX.pod

# cleanup modules which we package separately
rm -r %buildroot%privlib/Archive/Tar* %buildroot%_bindir/ptar*
rm -r %buildroot%privlib/autodie* %buildroot%privlib/Fatal.pm
rm -r %buildroot%privlib/Attribute/Handlers*
#rm %buildroot%privlib/B/Debug.pm
rm -r %buildroot%privlib/CPAN* %buildroot%privlib/App/Cpan.pm %buildroot%_bindir/cpan*
rm -r %buildroot{%privlib,%archlib,%autolib}/Compress
rm -r %buildroot%_bindir/streamzip
rm %buildroot%privlib/Devel/SelfStubber.pm
rm -r %buildroot{%archlib,%autolib}/Digest/SHA* %buildroot%_bindir/shasum
rm -r %buildroot{%privlib,%archlib,%autolib}/Encode*
rm %buildroot%archlib/encoding.pm %buildroot%_bindir/{enc2xs,encguess,piconv}
rm %buildroot%privlib/encoding/warnings.pm
rm %buildroot%privlib/experimental.pm
rm %buildroot%privlib/stable.pm
rm -r %buildroot%privlib/ExtUtils/CBuilder*
rm -r %buildroot%privlib/Filter*
rm %buildroot%privlib/File/Fetch.pm
rm -r %buildroot{%archlib,%autolib}/Filter*
rm %buildroot%privlib/HTTP/Tiny.pm
rm -r %buildroot%privlib/JSON* %buildroot%_bindir/json*
rm -r %buildroot%privlib/I18N/LangTags*
rm %buildroot%privlib/I18N/Collate.pm
rm -r %buildroot%privlib/IO/{Compress,Uncompress} %buildroot%privlib/File/GlobMapper.pm
rm %buildroot%privlib/IO/Socket/IP.pm
rm -r %buildroot%privlib/IO/Zlib.pm
rm %buildroot%privlib/IPC/Cmd.pm
#rm -r %buildroot{%archlib,%autolib}/IPC/SysV* %buildroot%archlib/IPC/{Msg,Semaphore,SharedMem}.pm
find %buildroot%privlib/Net/* -not -name '*ent.*' -print -delete
rm %buildroot%_bindir/libnetcfg
rm -r %buildroot%privlib/Locale
rm -r %buildroot{%privlib,%archlib,%autolib}/Math/Big* %buildroot%privlib/big*.pm
rm -r %buildroot%privlib/Math/{Complex,Trig}.pm
rm -r %buildroot%privlib/Memoize*
rm -r %buildroot%privlib/Module/Load*
rm -r %buildroot%privlib/Module/CoreList* %buildroot%_bindir/corelist
rm %buildroot%privlib/Module/Metadata.pm
rm %buildroot%privlib/NEXT.pm
rm %buildroot%privlib/Params/Check.pm
rm %buildroot%privlib/Parse/CPAN/Meta.pm
rm %buildroot%privlib/Perl/OSType.pm
rm %buildroot%privlib/Pod/Escapes.pm
rm %buildroot%privlib/Pod/{Checker,Usage}.pm
rm %buildroot%_bindir/{pod2usage,podchecker}
rm -r %buildroot%privlib/Pod/{Man,ParseLink,Text}*
rm %buildroot%_bindir/{pod2man,pod2text}
rm -r %buildroot%privlib/Pod/Perldoc* %buildroot%_bindir/perldoc
rm -r %buildroot%privlib/Pod/Simple*
rm %buildroot%privlib/Term/ANSIColor.pm
rm %buildroot%privlib/Term/Cap.pm
rm %buildroot%privlib/Term/ReadLine.pm
rm -r %buildroot%privlib/Text/Balanced*
rm %buildroot%privlib/Tie/File.pm
rm %buildroot%privlib/Tie/RefHash.pm
rm -r %buildroot{%archlib,%autolib}/Time/Piece* %buildroot%archlib/Time/Seconds.pm
rm -r %buildroot{%privlib,%archlib,%autolib}/Unicode/Collate*

rm %buildroot%_bindir/zipdetails
rm %buildroot%privlib/perlfaq.pm

# cleanup Perl4-CoreLibs
grep -lZ '^warn "Legacy library' %buildroot%privlib/*.pl |xargs -r0 rm -fv --

# further cleanup #"
%if_without file_spec_other_os
rm %buildroot%archlib/File/Spec/{Cygwin,Epoc,Mac,OS2,VMS,Win32}.pm
%endif
rm %buildroot%privlib/ExtUtils/MM_{AIX,BeOS,Cygwin,Darwin,DOS,MacOS,NW5,OS2,OS390,QNX,UWIN,VMS,VOS,Win32,Win95}.pm
rm %buildroot%privlib/ExtUtils/PL2Bat.pm
rm %buildroot%_bindir/perlivp

mkdir -p %buildroot%_rpmlibdir
cat <<EOF >%buildroot%_rpmlibdir/perl-base-files.req.list
# perl-base dirlist for %_rpmlibdir/files.req
/usr/lib/perl5	perl-base
/usr/lib64/perl5	perl-base
/usr/share/perl5	perl-base
/etc/perl5	perl-base
/usr/lib/perl5/vendor_perl	perl-base
EOF

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d/
echo perl >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/perl-base

%if_with boorstrap_perl_wrapper
cat > %buildroot%_bindir/perl-bootstrap-wrapper <<'EOF'
#!/bin/sh
# bootstrap
buildroot_perl5=/usr/src/tmp/perl-buildroot/usr/bin/perl%version
if [ -e $buildroot_perl5 ]; then
export LD_PRELOAD=/usr/src/tmp/perl-buildroot%_libdir/libperl-5.38.so
exec $buildroot_perl5 "$@"
fi
exec /usr/bin/perl%version "$@"
EOF
chmod 755 %buildroot%_bindir/perl-bootstrap-wrapper
ln -sf perl-bootstrap-wrapper %buildroot%_bindir/perl
%endif


%files	base
%doc	Artistic AUTHORS README
	%_bindir/perl
	%_bindir/perl5*
%if_with boorstrap_perl_wrapper
	%_bindir/perl-bootstrap-wrapper
%endif
	%_libdir/libperl-%ver.so
# skeleton
%dir	%privlib
%dir	%privlib/auto
%dir	%archlib
%dir	%autolib
%dir	/etc/perl5
%dir	/usr/lib/perl5/vendor_perl
%config %_rpmlibdir/perl-base-files.req.list
%config %_sysconfdir/buildreqs/packages/substitute.d/perl-base
# pragma
	%archlib/attributes.pm
	%autolib/attributes
	%privlib/autouse.pm
	%privlib/base.pm
	%privlib/bytes*
	%privlib/constant.pm
	%privlib/deprecate.pm
	%privlib/feature.pm
	%privlib/fields.pm
	%privlib/filetest.pm
	%privlib/if.pm
	%privlib/integer.pm
	%privlib/less.pm
	%archlib/lib.pm
	%privlib/locale.pm
	%privlib/meta_notation.pm
	%archlib/mro.pm
	%autolib/mro
	%privlib/open.pm
	%archlib/ops.pm
	%privlib/overload*
	%archlib/re.pm
	%autolib/re
	%privlib/sigtrap.pm
	%privlib/sort.pm
	%privlib/strict.pm
	%privlib/subs.pm
	%privlib/utf8*
	%privlib/vars.pm
	%privlib/version.pm
%doc	%privlib/version.pod
%dir	%privlib/version
	%privlib/version/regex.pm
#	%privlib/version/vpp.pm
%doc	%privlib/version/Internals.pod
	%privlib/vmsish.pm
	%privlib/warnings*
	%privlib/builtin.pm
# module loaders
	%privlib/AutoLoader.pm
	%archlib/DynaLoader.pm
	%privlib/SelfLoader.pm
	%privlib/XSLoader.pm
# data utils
%dir	%archlib/Hash
	%archlib/Hash/Util*
%dir	%autolib/Hash
	%autolib/Hash/Util*
%dir	%archlib/List
	%archlib/List/Util*
%dir	%autolib/List
	%autolib/List/Util*
%dir	%archlib/Scalar
	%archlib/Scalar/Util*
%dir	%archlib/Sub
	%archlib/Sub/Util*
# initial unicode support
%dir	%privlib/unicore
%dir	%privlib/unicore/To
	%privlib/unicore/To/Cf.pl
	%privlib/unicore/To/Lc.pl
	%privlib/unicore/To/Tc.pl
	%privlib/unicore/To/Uc.pl
%dir	%privlib/unicore/lib
%dir	%privlib/unicore/lib/Alpha
	%privlib/unicore/lib/Alpha/Y.pl
%dir	%privlib/unicore/lib/Cased
	%privlib/unicore/lib/Cased/Y.pl
%dir	%privlib/unicore/lib/Gc
	%privlib/unicore/lib/Gc/Nd.pl
	%privlib/unicore/lib/Gc/P.pl
%dir	%privlib/unicore/lib/Hex
	%privlib/unicore/lib/Hex/Y.pl
%dir	%privlib/unicore/lib/Lower
	%privlib/unicore/lib/Lower/Y.pl
%dir	%privlib/unicore/lib/Nt
	%privlib/unicore/lib/Nt/Di.pl
	%privlib/unicore/lib/Nt/Nu.pl
%dir	%privlib/unicore/lib/Perl
	%privlib/unicore/lib/Perl/_PerlIDS.pl
	%privlib/unicore/lib/Perl/Alnum.pl
	%privlib/unicore/lib/Perl/Blank.pl
	%privlib/unicore/lib/Perl/Graph.pl
	%privlib/unicore/lib/Perl/Print.pl
	%privlib/unicore/lib/Perl/Word.pl
%dir	%privlib/unicore/lib/Upper
	%privlib/unicore/lib/Upper/Y.pl
	%privlib/unicore/uni_keywords.pl
# modules
	%privlib/Carp*
	%archlib/Config.pm
	%archlib/Config_heavy.pl
	%archlib/Config_git.pl
%dir	%privlib/Config
	%privlib/Config/Extensions.pm
%dir	%privlib/Config/Perl
	%privlib/Config/Perl/V.pm
%dir	%privlib/Class
	%privlib/Class/Struct.pm
	%archlib/Cwd.pm
	%autolib/Cwd
%dir	%archlib/Data
	%archlib/Data/Dumper.pm
%dir	%autolib/Data
	%autolib/Data/Dumper
	%privlib/Digest.pm
%dir	%privlib/Digest
	%privlib/Digest/base.pm
	%privlib/Digest/file.pm
%dir	%archlib/Digest
	%archlib/Digest/MD5.pm
%dir	%autolib/Digest
	%autolib/Digest/MD5
	%privlib/English.pm
	%archlib/Errno.pm
	%privlib/Exporter*
	%archlib/Fcntl.pm
	%autolib/Fcntl
%dir	%privlib/File
	%privlib/File/Basename.pm
	%privlib/File/Compare.pm
	%privlib/File/Copy.pm
	%privlib/File/Find.pm
	%privlib/File/Path.pm
	%privlib/File/stat.pm
	%privlib/File/Temp.pm
	%privlib/FileHandle.pm
%dir	%archlib/File
	%archlib/File/Glob.pm
	%archlib/File/DosGlob.pm
%dir	%autolib/File
	%autolib/File/Glob
	%autolib/File/DosGlob
	%archlib/File/Spec*
	%privlib/FindBin.pm
%dir	%privlib/Getopt
	%privlib/Getopt/Long.pm
	%privlib/Getopt/Std.pm
	%archlib/IO.pm
%dir	%archlib/IO
	%archlib/IO/Dir.pm
	%archlib/IO/File.pm
	%archlib/IO/Handle.pm
	%archlib/IO/Pipe.pm
	%archlib/IO/Poll.pm
	%archlib/IO/Seekable.pm
	%archlib/IO/Select.pm
	%archlib/IO/Socket*
%dir	%autolib/IO
	%autolib/IO/IO.so
%dir	%privlib/IPC
	%privlib/IPC/Open2.pm
	%privlib/IPC/Open3.pm
%dir	%archlib/MIME
	%archlib/MIME/Base64.pm
	%archlib/MIME/QuotedPrint.pm
%dir	%autolib/MIME
	%autolib/MIME/Base64
	%privlib/PerlIO*
	%archlib/PerlIO*
	%autolib/PerlIO*
	%archlib/POSIX.pm
	%autolib/POSIX
	%privlib/SelectSaver.pm
	%archlib/Socket.pm
	%autolib/Socket
	%archlib/Storable.pm
	%autolib/Storable
	%privlib/Symbol.pm
%dir	%archlib/Sys
	%archlib/Sys/Hostname.pm
	%archlib/Sys/Syslog.pm
%dir	%autolib/Sys
	%autolib/Sys/Hostname
	%autolib/Sys/Syslog
%dir	%privlib/Text
	%privlib/Text/Abbrev.pm
	%privlib/Text/ParseWords.pm
	%privlib/Text/Tabs.pm
	%privlib/Text/Wrap.pm
%dir	%privlib/Tie
	%privlib/Tie/Array.pm
	%privlib/Tie/Handle.pm
	%privlib/Tie/Hash*
	%privlib/Tie/Memoize.pm
	%privlib/Tie/Scalar.pm
	%privlib/Tie/StdHandle.pm
	%privlib/Tie/SubstrHash.pm
%dir	%privlib/Time
	%privlib/Time/gmtime.pm
	%privlib/Time/localtime.pm
	%privlib/Time/tm.pm
	%privlib/Time/Local.pm
%dir	%archlib/Time
	%archlib/Time/HiRes.pm
%dir	%autolib/Time
	%autolib/Time/HiRes
	%privlib/UNIVERSAL.pm
# required for perl.req and perl.prov
	%archlib/B.pm
%dir	%autolib/B
	%autolib/B/B.so
	%archlib/O.pm
	%archlib/Opcode.pm
	%autolib/Opcode
	%privlib/Safe.pm
# IPC-SysV: required for Test-Simple in perl-devel
%dir	%archlib/IPC
	%archlib/IPC/Msg.pm
	%archlib/IPC/Semaphore.pm
	%archlib/IPC/SharedMem.pm
	%archlib/IPC/SysV.pm
%dir	%autolib/IPC
%dir	%autolib/IPC/SysV
	%autolib/IPC/SysV/SysV.so
# rarely used but part of perl
	%privlib/Benchmark.pm
%doc	%privlib/CORE.pod
	%privlib/DirHandle.pm
	%privlib/Env.pm
	%privlib/FileCache.pm
%dir	%archlib/I18N
	%archlib/I18N/Langinfo.pm
%dir	%autolib/I18N
	%autolib/I18N/Langinfo
%dir	%privlib/Net
	%privlib/Net/*ent.pm
%dir	%privlib/Pod
	%privlib/Pod/Functions.pm
%dir	%privlib/Search
	%privlib/Search/Dict.pm
%dir	%privlib/Term
	%privlib/Term/Complete.pm
%dir	%privlib/User
	%privlib/User/*ent.pm
# in separate package perl-parent; required in buildroot for tests
%exclude %privlib/parent.pm

%files	devel
	%_bindir/h2xs
	%_bindir/instmodsh
	%_bindir/perlbug
	%_bindir/perlthanks
	%_bindir/prove
	%_bindir/xsubpp
# perl4-compat scripts
	%_bindir/h2ph
	%_bindir/pl2pm
	%privlib/blib.pm
	%privlib/dumpvar.pl
	%privlib/perl5db.pl
	%privlib/Dumpvalue.pm
%dir	%archlib/CORE
	%archlib/CORE/*.h
	%archlib/CORE/libperl*.so
# perl-devel modules
	%privlib/AutoSplit.pm
	%privlib/B
	%archlib/B
	%autolib/B
%exclude %autolib/B/B.so
	%privlib/DB.pm
%dir	%archlib/Devel
	%archlib/Devel/Peek.pm
	%archlib/Devel/PPPort.pm
%dir	%autolib/Devel
	%autolib/Devel/Peek
	# explicitly ignored in installperl
	#%autolib/Devel/PPPort
%dir	%privlib/ExtUtils
	%privlib/ExtUtils/Command*
	%privlib/ExtUtils/Constant*
	%privlib/ExtUtils/Embed.pm
	%privlib/ExtUtils/Install.pm
	%privlib/ExtUtils/Installed.pm
	%privlib/ExtUtils/Liblist*
	%privlib/ExtUtils/MakeMaker.pm
%dir	%privlib/ExtUtils/MakeMaker
	%privlib/ExtUtils/MakeMaker/*.pm
	# explicitly ignored in installperl; returned by tmp hack (Patch18)
%dir	%privlib/ExtUtils/MakeMaker/version
	%privlib/ExtUtils/MakeMaker/version/*.pm
%doc	%privlib/ExtUtils/MakeMaker/*.pod
	%privlib/ExtUtils/MM.pm
	%privlib/ExtUtils/MM_Any.pm
	%privlib/ExtUtils/MM_Unix.pm
	%privlib/ExtUtils/MY.pm
	%privlib/ExtUtils/MANIFEST.SKIP
	%privlib/ExtUtils/Manifest.pm
	%privlib/ExtUtils/Miniperl.pm
	%privlib/ExtUtils/Mkbootstrap.pm
	%privlib/ExtUtils/Mksymlists.pm
	%privlib/ExtUtils/Packlist.pm
%dir	%privlib/ExtUtils/ParseXS
	%privlib/ExtUtils/ParseXS/*.pm
	%privlib/ExtUtils/ParseXS.pm
%doc	%privlib/ExtUtils/ParseXS.pod
%dir	%privlib/ExtUtils/Typemaps
	%privlib/ExtUtils/Typemaps/*.pm
	%privlib/ExtUtils/Typemaps.pm
	%privlib/ExtUtils/testlib.pm
	%privlib/ExtUtils/typemap
	%privlib/ExtUtils/xsubpp
	%privlib/Test.pm
%dir	%privlib/Test
%doc	%privlib/Test/Tutorial.pod
# Test-Simple pieces
	%privlib/ok.pm
	%privlib/Test/Builder*
	%privlib/Test/More.pm
	%privlib/Test/Simple.pm
%dir	%privlib/Test/use
	%privlib/Test/use/ok.pm
	%privlib/Test/Tester.pm
%dir	%privlib/Test/Tester
	%privlib/Test/Tester/Capture.pm
	%privlib/Test/Tester/CaptureRunner.pm
	%privlib/Test/Tester/Delegate.pm
	%privlib/Test2.pm
%dir	%privlib/Test2
	%privlib/Test2/API.pm
%dir	%privlib/Test2/API
	%privlib/Test2/API/Breakage.pm
	%privlib/Test2/API/Context.pm
	%privlib/Test2/API/Instance.pm
	%privlib/Test2/API/InterceptResult.pm
%dir	%privlib/Test2/API/InterceptResult
	%privlib/Test2/API/InterceptResult/Event.pm
	%privlib/Test2/API/InterceptResult/Facet.pm
	%privlib/Test2/API/InterceptResult/Hub.pm
	%privlib/Test2/API/InterceptResult/Squasher.pm
	%privlib/Test2/API/Stack.pm
	%privlib/Test2/Event.pm
%dir	%privlib/Test2/Event
	%privlib/Test2/Event/Bail.pm
	%privlib/Test2/Event/Diag.pm
	%privlib/Test2/Event/Encoding.pm
	%privlib/Test2/Event/Exception.pm
	%privlib/Test2/Event/Fail.pm
	%privlib/Test2/Event/Generic.pm
	%privlib/Test2/Event/Note.pm
	%privlib/Test2/Event/Ok.pm
	%privlib/Test2/Event/Pass.pm
	%privlib/Test2/Event/Plan.pm
	%privlib/Test2/Event/Skip.pm
	%privlib/Test2/Event/Subtest.pm
%dir	%privlib/Test2/Event/TAP
	%privlib/Test2/Event/TAP/Version.pm
	%privlib/Test2/Event/V2.pm
	%privlib/Test2/Event/Waiting.pm
	%privlib/Test2/EventFacet.pm
%dir	%privlib/Test2/EventFacet
	%privlib/Test2/EventFacet/About.pm
	%privlib/Test2/EventFacet/Amnesty.pm
	%privlib/Test2/EventFacet/Assert.pm
	%privlib/Test2/EventFacet/Control.pm
	%privlib/Test2/EventFacet/Error.pm
	%privlib/Test2/EventFacet/Hub.pm
	%privlib/Test2/EventFacet/Info.pm
%dir	%privlib/Test2/EventFacet/Info
	%privlib/Test2/EventFacet/Info/Table.pm
	%privlib/Test2/EventFacet/Meta.pm
	%privlib/Test2/EventFacet/Parent.pm
	%privlib/Test2/EventFacet/Plan.pm
	%privlib/Test2/EventFacet/Render.pm
	%privlib/Test2/EventFacet/Trace.pm
	%privlib/Test2/Formatter.pm
%dir	%privlib/Test2/Formatter
	%privlib/Test2/Formatter/TAP.pm
	%privlib/Test2/Hub.pm
%dir	%privlib/Test2/Hub
	%privlib/Test2/Hub/Interceptor.pm
%dir	%privlib/Test2/Hub/Interceptor
	%privlib/Test2/Hub/Interceptor/Terminator.pm
	%privlib/Test2/Hub/Subtest.pm
	%privlib/Test2/IPC.pm
%dir	%privlib/Test2/IPC
	%privlib/Test2/IPC/Driver.pm
%dir	%privlib/Test2/IPC/Driver
	%privlib/Test2/IPC/Driver/Files.pm
%dir	%privlib/Test2/Tools
	%privlib/Test2/Tools/Tiny.pm
	%privlib/Test2/Transition.pod
	%privlib/Test2/Util.pm
%dir	%privlib/Test2/Util
	%privlib/Test2/Util/ExternalMeta.pm
	%privlib/Test2/Util/Facets2Legacy.pm
	%privlib/Test2/Util/HashBase.pm
	%privlib/Test2/Util/Trace.pm
# Test-Harness pieces
%dir	%privlib/App
	%privlib/App/Prove*
	%privlib/TAP
	%privlib/Test/Harness.pm

%files	pod
%dir	%privlib/pod
%doc	%privlib/pod/perl*.pod
%exclude %privlib/pod/perldiag.pod
%exclude %privlib/pod/perldbmfilter.pod
%doc	%privlib/Config.pod
%doc	%privlib/POSIX.pod
%doc	%privlib/Internals.pod

%files	threads
	%privlib/Thread*
	%archlib/threads*
	%autolib/threads

%files	unicore
	%privlib/charnames.pm
	%privlib/_charnames.pm
%dir	%privlib/Unicode
	%privlib/Unicode/UCD.pm
%dir	%privlib/unicore
	%privlib/unicore/version
	%privlib/unicore/Name.pm
	%privlib/unicore/Name.pl
	%privlib/unicore/UCD.pl
	%privlib/unicore/lib/

%exclude %privlib/unicore/lib/Alpha/Y.pl
%exclude %privlib/unicore/lib/Cased/Y.pl
%exclude %privlib/unicore/lib/Gc/Nd.pl
%exclude %privlib/unicore/lib/Gc/P.pl
%exclude %privlib/unicore/lib/Hex/Y.pl
%exclude %privlib/unicore/lib/Lower/Y.pl
%exclude %privlib/unicore/lib/Nt/Di.pl
%exclude %privlib/unicore/lib/Nt/Nu.pl
%exclude %privlib/unicore/lib/Perl/_PerlIDS.pl
%exclude %privlib/unicore/lib/Perl/Alnum.pl
%exclude %privlib/unicore/lib/Perl/Blank.pl
%exclude %privlib/unicore/lib/Perl/Graph.pl
%exclude %privlib/unicore/lib/Perl/Print.pl
%exclude %privlib/unicore/lib/Perl/Word.pl
%exclude %privlib/unicore/lib/Upper/Y.pl
	%privlib/unicore/To/
%exclude %privlib/unicore/To/Cf.pl
%exclude %privlib/unicore/To/Lc.pl
%exclude %privlib/unicore/To/Tc.pl
%exclude %privlib/unicore/To/Uc.pl
# required to build Unicode::Normalize
	%privlib/unicore/CombiningClass.pl
	%privlib/unicore/Decomposition.pl
# required for Unicode::UCD
	%privlib/unicore/Blocks.txt
	%privlib/unicore/SpecialCasing.txt
# not required
	%privlib/unicore/NamedSequences.txt
# seems for self test only
%exclude %privlib/unicore/TestNorm.pl

%files	DBM
	%privlib/AnyDBM_File.pm
	%archlib/DB_File.pm
	%autolib/DB_File
	%archlib/NDBM_File.pm
	%autolib/NDBM_File
	%archlib/GDBM_File.pm
	%autolib/GDBM_File
	%archlib/SDBM_File.pm
	%autolib/SDBM_File
	%privlib/DBM_Filter*
%dir	%privlib/pod
%doc	%privlib/pod/perldbmfilter.pod

%files	Unicode-Normalize
%dir	%archlib/Unicode
	%archlib/Unicode/Normalize.pm
	%autolib/Unicode

%files	Pod-Html
%dir	%privlib/Pod
	%privlib/Pod/Html.pm
%dir	%privlib/Pod/Html
	%privlib/Pod/Html/Util.pm
	%_bindir/pod2html

%files	diagnostics
	%_bindir/splain
	%privlib/diagnostics.pm
%dir	%privlib/pod
# perldiag.pod is NOT a doc; it used by diagnostics.pm
%doc	%privlib/pod/perldiag.pod

%changelog
