Name: perfctr
Summary: Linux performance monitoring counters software
Version: 2.6.42
Release: alt1.qa1
License: LGPL
Group: Development/Tools
URL: http://user.it.uu.se/~mikpe/linux/perfctr/
Source: %name-%version.tar.gz
Source1: init.info
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>
Requires: lib%name = %version-%release
ExcludeArch: aarch64 ppc64le

%description
This package adds support for using the Performance-Monitoring
Counters (PMCs) found in many modern processors.

PMCs are "event counters" capable of recording any of a large
number of performance-related events during execution.
These events typically include instructions executed, cache
misses, TLB misses, stalls, and other events specific to
the microarchitecture of the processor being used.

PMCs are primarily used to identify low-level performance problems,
and to validate code changes intended to improve performance.

%package -n lib%name
Summary: Shared libraries for perfctr
Group: Development/C

%description -n lib%name
Shared libraries for perfctr.

%package -n lib%name-devel
Summary: Development library for perfctr
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
The perfctr-devel package contains object files
necessary for developing programs which use the perfctr C library.

%package -n lib%name-devel-static
Summary: Static library for perfctr
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
Static library for perfctr.

%prep
%setup
install %SOURCE1 .

%build
cp linux/include/linux/perfctr.h linux/include/
%make_build

%install
%makeinstall install2 \
	PREFIX=%buildroot%prefix \
	BINDIR=%buildroot%_bindir \
	LIBDIR=%buildroot%_libdir \
	INCLDIR=%buildroot%_includedir \
	ETCDIR=%buildroot%_sysconfdir

mv %buildroot%_includedir/linux/%name.h \
	%buildroot%_includedir/
mv %buildroot%_includedir/asm/%name.h \
	%buildroot%_includedir/asm_%name.h
sed -i 's|asm/%name.h|asm_%name.h|' \
	%buildroot%_includedir/%name.h
# _udevrulesdir fix
mkdir -p %buildroot%{_udevrulesdir}
mv %buildroot%_sysconfdir/udev/rules.d/* %buildroot%{_udevrulesdir}/


%post
%post_service %name

%preun
%preun_service %name

%files
%_bindir/perfex
%config %_initdir/perfctr
%{_udevrulesdir}/*perfctr.rules

%doc README CHANGES TODO OTHER

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*.h

%files -n lib%name-devel-static
%_libdir/*.a

%changelog
