%define _unpackaged_files_terminate_build 1
%def_disable static
%def_enable polkit
%def_enable systemd

Name: pcsc-lite
Version: 2.4.0
Release: alt1

Summary: PC/SC Lite smart card framework and applications
License: BSD-3-Clause AND BSD-2-Clause AND GPL-3.0-or-later
Group: System/Servers

URL: https://pcsclite.apdu.fr/

Source: %name-%version.tar

Source1: pcscd.init
Source3: pcsc-lite.tmpfiles

Requires: pcsc-ifd-handler
Requires: libpcsclite = %version-%release
%{?_enable_polkit:Requires: polkit}

BuildRequires(pre): rpm-macros-python3 rpm-macros-meson
BuildRequires: rpm-build-python3 meson
BuildRequires: perl-podlators
BuildRequires: flex
BuildRequires: pkgconfig(libudev)

%{?_enable_polkit:BuildRequires: pkgconfig(polkit-gobject-1)}
%{?_enable_systemd:BuildRequires: pkgconfig(libsystemd) pkgconfig(systemd)}

%if_enabled static
BuildRequires: glibc-devel-static
%endif

%description
pcscd is the daemon program for PC/SC Lite. It is a resource
manager that coorinates communications with Smart Card readers and Smart
Cards that are connected to the system.
The purpose of PCSC Lite is to provide a Windows(R) SCard interface
in a very small form factor for communicating to smartcards and readers.
PCSC Lite uses the same winscard api as used under Windows(R)

This package contains the service for PC/SC Lite.

%package -n libpcsclite
Group: System/Libraries
Summary: Libraries for pcscd

%description -n libpcsclite
Libraries for pcscd. pcscd is the daemon program
for PC/SC Lite. It is a resource manager that coorinates
communications with Smart Card readers and Smart Cards
that are connected to the system. The purpose of PCSC Lite
is to provide a Windows(R) SCard interface in a very small
form factor for communicating to smartcards and readers.
PCSC Lite uses the same winscard api as used under Windows(R)

%package -n libpcsclite-devel
Group: Development/C
Summary: Haeders and other development files for libpcsclite
Requires: libpcsclite = %EVR

%description -n libpcsclite-devel
Haeders and other development files for libpcsclite

%package -n libpcsclite-devel-static
Group: Development/C
Summary: Static libraries for libpcsclite
Requires: libpcsclite-devel = %EVR

%description -n libpcsclite-devel-static
Static libraries for libpcsclite

%prep
%setup

%build
%meson \
    -Dlibsystemd=true \
    -Dsystemdunit=system \
    -Dserial=true \
    -Dusb=true \
    %{?_enable_polkit:-Dpolkit=true} \
    -Dusbdropdir=%_libdir/pcsc/drivers \
    -Dipcdir=/run/pcscd

%meson_build

%install
%meson_install

install -pDm755 %SOURCE1 %buildroot%_initdir/pcscd

mkdir -p %buildroot%_sysconfdir/reader.conf.d
mkdir -p %buildroot%_libdir/pcsc/drivers
mkdir -p %buildroot%_sysconfdir/sysconfig
mv -fv %buildroot%_sysconfdir/default/pcscd %buildroot%_sysconfdir/sysconfig/pcscd
sed -i -e 's|/etc/default/pcscd|%_sysconfdir/sysconfig/pcscd|' %buildroot%_unitdir/pcscd.service
mkdir -p %buildroot%_tmpfilesdir
install -pDm644 %SOURCE3 %buildroot%_tmpfilesdir/pcsc-lite.conf

# remove default installed docs
rm -rf %buildroot%_defaultdocdir/pcsc-lite

%if_disabled static
# remove static archives .a
rm -f %buildroot%_libdir/libpcsclite.a
%endif

%preun
if sd_booted; then
    %preun_systemd pcscd.service pcscd.socket
else
    %preun_service pcscd
fi

%post
if sd_booted; then
    %post_systemd pcscd.service pcscd.socket
else
    %post_service pcscd
fi

%files
%doc AUTHORS COPYING HELP README* SECURITY doc/README.polkit
%dir %_sysconfdir/reader.conf.d
%config(noreplace) %_sysconfdir/sysconfig/pcscd
%_initdir/pcscd
%if_enabled systemd
%_unitdir/pcscd.*
%_libexecdir/sysusers.d/pcscd-sysusers.conf
%endif
%_tmpfilesdir/pcsc-lite.conf
%_sbindir/pcscd
#_bindir/make_hash_link.sh
%_man5dir/*
%_man8dir/*
%dir %_libdir/pcsc
%dir %_libdir/pcsc/drivers
%{?_enable_polkit:%_datadir/polkit-1/actions/*.policy}
%_datadir/metainfo/fr.apdu.pcsclite.metainfo.xml

# NB: .so belongs here, see ALT#25275
%files -n libpcsclite
%_libdir/libpcsclite.so.*
%_libdir/libpcsclite.so
%_libdir/libpcsclite_real.so.*
%_libdir/libpcsclite_real.so

%files -n libpcsclite-devel
%doc ChangeLog
%_bindir/pcsc-spy
%_libdir/libpcscspy.so*
%_includedir/PCSC
%_pkgconfigdir/libpcsclite.pc
%_man1dir/pcsc-spy.*

%if_enabled static
%files -n libpcsclite-devel-static
%_libdir/libpcsclite.a
%endif

%changelog
