%define libname libpci
%define soname 3

Name: pciutils
Version: 3.14.0
Release: alt1

Summary: Linux PCI utilities
License: GPLv2
Group: System/Kernel and hardware

Url: https://mj.ucw.cz/sw/pciutils/
VCS: https://github.com/pciutils/pciutils
# git://git.kernel.org/pub/scm/utils/pciutils/pciutils.git
Source: %name-%version.tar

Requires: pciids
Requires: %libname = %EVR

Summary(ru_RU.UTF-8): Утилиты для работы с PCI в Linux
Summary(uk_UA.UTF-8): Утиліти для роботи з PCI в Linux

%description
This package contains various utilities for inspecting
and setting devices connected to the PCI bus.

%description -l ru_RU.UTF-8
Этот пакет содержит несколько утилит для просмотра и настройки
устройств, подключенных к шине PCI.

%description -l uk_UA.UTF-8
Цей пакунок містить декілька утиліт для перегляду й налаштування
пристроїв, які підключено до шини PCI.

%package -n %libname
Summary: Linux PCI library
Group: System/Libraries

%description -n %libname
This package contains shared library for inspecting and setting
devices connected to the PCI bus.

%package -n %libname-devel
Summary: Linux PCI development library
Group: Development/C
Requires: %libname = %EVR
Provides: %name-devel = %EVR

%description -n %libname-devel
This package contains PCI library headers.

%prep
%setup

%build
%make_build \
	SHARED=yes \
	LIBDIR=%_libdir \
	OPT="%optflags" \
	PREFIX=%_prefix \
	IDSDIR=%_datadir/misc

%install
%make_install \
	SHARED=yes \
	PREFIX=%_prefix \
	LIBDIR=%_libdir \
	DESTDIR=%buildroot \
	SBINDIR=%_sbindir \
	BINDIR=%_bindir \
	install install-lib

%files
%doc README TODO ChangeLog *.lsm
%_bindir/lspci
%_sbindir/setpci
%_sbindir/pcilmr
%_man8dir/lspci*
%_man8dir/setpci*
%_man8dir/pcilmr*

%files -n %libname
%_libdir/*.so.%soname
%_libdir/*.so.%soname.*

%files -n %libname-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
%_man7dir/pcilib*

%changelog
