Name: patchage
Version: 1.0.10
Release: alt1

Summary: A modular patch bay for JACK and LASH audio systems
License: GPL-2.0+
Group: Sound
Url: https://drobilla.net/software/patchage

Source0: %name-%version.tar

BuildRequires(pre): meson ninja-build
BuildRequires: doxygen graphviz libganv-devel
BuildRequires: gcc-c++ libflowcanvas-devel boost-devel
BuildRequires: libglademm-devel libalsa-devel libjack-devel
BuildRequires: desktop-file-utils libdbus-devel libdbus-glib-devel

%description
Patchage is a modular patch bay for audio and MIDI systems based on
Jack, Lash, and Alsa.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install

%find_lang %name
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Application \
	--add-category=Midi \
	%buildroot%_desktopdir/patchage.desktop

%files -f %name.lang
%doc AUTHORS NEWS README.md
%_bindir/*
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*.png
%_iconsdir/hicolor/*/apps/*.svg
%_datadir/%name/*
%_man1dir/%name.1*

%changelog
