Name: passwdqc
Version: 2.0.3
Release: alt3

Summary: A passphrase strength checking and policy enforcement toolset
License: LGPLv2+
Group: System/Base
Url: https://www.openwall.com/passwdqc/

# https://git.altlinux.org/gears/p/passwdqc.git
Source: %name-%version-%release.tar

# due to PAM policy.
BuildRequires(pre): libpam-devel
# due to change in format of PAM modules requirements.
BuildRequires: rpm-build >= 0:4.0.4-alt55

BuildRequires: libaudit-devel

%set_pam_name pam_%name

%package control
Summary: Control rules for the passwdqc passphrase quality checker
License: GPLv2+
Group: System/Base
BuildArch: noarch

%package -n lib%name
Summary: Passphrase quality checker shared library
License: LGPLv2+
Group: System/Libraries
Requires(pre,post): %name-control = %version-%release

%package -n lib%name-devel
Summary: Library and header file for building passwdqc-aware applications
License: LGPLv2+
Group: Development/C
Requires: lib%name = %version-%release

%package utils
Summary: Password quality checker utilities
License: GPLv2+
Group: System/Base
Requires: lib%name = %version-%release

%package -n %pam_name
Summary: Pluggable passphrase quality checker
License: LGPLv2+
Group: System/Base
Provides: pam_%name = %version-%release
Obsoletes: pam_%name
Requires: lib%name = %version-%release

%description
passwdqc is a password/passphrase strength checking and policy
enforcement toolset, including a PAM module (pam_passwdqc), command-line
programs (pwqcheck, pwqfilter, and pwqgen), and a library (libpasswdqc).

pam_passwdqc is normally invoked on passphrase changes by programs
such as passwd(1).  It is capable of checking password or passphrase
strength, enforcing a policy, and offering randomly-generated
passphrases, with all of these features being optional and easily
(re-)configurable.

pwqcheck and pwqgen are standalone passphrase strength checking and
random passphrase generator programs, respectively, which are usable
from scripts.

The pwqfilter program searches, creates, or updates binary passphrase
filter files, which can also be used with pwqcheck and pam_passwdqc.

libpasswdqc is the underlying library, which may also be used from
third-party programs.

%description control
This package contains control rules for passphrase strength
checking library.  See control(8) for details.

%description -n lib%name
The libpasswdqc is a passphrase strength checking library.
In addition to checking regular passphrases, it offers support
for passphrases and can provide randomly generated passphrases.
All features are optional and can be (re-)configured without
rebuilding.

This package contains shared passwdqc library.

%description -n lib%name-devel
The libpasswdqc is a passphrase strength checking library.
In addition to checking regular passphrases, it offers support
for passphrases and can provide randomly generated passphrases.
All features are optional and can be (re-)configured without
rebuilding.

This package contains development library and header file
needed for building passwdqc-aware applications.

%description utils
This package contains standalone utilities which are usable from scripts:
pwqcheck (a standalone passphrase strength checking program),
pwqgen (a standalone random passphrase generator program), and
pwqfilter (a standalone program that searches, creates, or updates
binary passphrase filter files).

%description -n %pam_name
pam_passwdqc is a passphrase strength checking module for
PAM-aware passphrase changing programs, such as passwd(1).
In addition to checking regular passphrases, it offers support
for passphrases and can provide randomly generated passphrases.
All features are optional and can be (re-)configured without
rebuilding.

%prep
%setup -n %name-%version-%release

%build
%add_optflags -W -Werror
%make_build \
	CPPFLAGS="-DENABLE_NLS=1 -DHAVE_LIBAUDIT=1 -DLINUX_PAM=1 $(getconf LFS_CFLAGS)" \
	CFLAGS_bin='%optflags' \
	CFLAGS_lib='%optflags %optflags_shared' \
	all locales

%install
%makeinstall_std install_locales \
	CC=/bin/false LD=/bin/false \
	SHARED_LIBDIR=/%_lib DEVEL_LIBDIR=%_libdir SECUREDIR=/%_lib/security
install -pD -m755 passwdqc.control \
        %buildroot%_controldir/passwdqc-enforce
install -pD -m755 passwdqc-min.control \
        %buildroot%_controldir/passwdqc-min
install -pD -m755 passwdqc-match.control \
        %buildroot%_controldir/passwdqc-match

%find_lang passwdqc

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%pre -n lib%name
%pre_control passwdqc-enforce passwdqc-min passwdqc-match

%post -n lib%name
%post_control -s users passwdqc-enforce
%post_control -s default passwdqc-min
%post_control -s default passwdqc-match

%files control
%config %_controldir/*

%files -n lib%name -f passwdqc.lang
%config(noreplace) /etc/passwdqc.conf
/%_lib/lib*.so*
%_man5dir/*
%doc LICENSE README PLATFORMS *.php

%files -n lib%name-devel
%_includedir/*.h
%_libdir/lib*.so
%_pkgconfigdir/*.pc
%_man3dir/*

%files -n %pam_name
/%_lib/security/*
%_man8dir/*

%files utils
%_bindir/*
%_man1dir/*

%changelog
